/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability;

import java.time.Instant;
import java.util.Arrays;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.AbilityCondition;
import open.batoru.data.ability.ConstantEffect;
import open.batoru.data.ability.modifiers.ConstantModifier;
import open.batoru.game.FieldZoneAttachedAbilitiesIndicator;
import open.batoru.ui.FX;
import open.batoru.ui.UI;

public class ConstantAbility
extends Ability
implements ConstantEffect {
    private ConstantModifier[] listModifiers;
    private boolean lastMasterState;
    private int priority;
    private long lastEnabledTimestamp;

    public ConstantAbility(ConstantModifier ... listModifiers) {
        if (listModifiers.length == 0) {
            throw new IllegalArgumentException();
        }
        this.listModifiers = listModifiers;
        for (ConstantModifier modifier : listModifiers) {
            this.priority -= modifier.getPriority();
        }
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void onAbilityInit() {
        this.setModifiersSourceAbility();
        super.onAbilityInit();
    }

    public void setModifiersSourceAbility() {
        for (ConstantModifier modifier : this.listModifiers) {
            modifier.setSourceAbility(this);
        }
    }

    @Override
    public void update() {
        boolean masterState = this.getState();
        if (!this.lastMasterState && masterState) {
            this.updateLastEnabledTimestamp();
        }
        for (ConstantModifier modifier : this.listModifiers) {
            boolean state = masterState && modifier.getCondition().getState(this.getSourceCardIndex()) != AbilityCondition.ConditionState.BAD;
            boolean lastState = modifier.getLastState(this.getSourceCardIndex());
            if (state && lastState && modifier.shouldForceUpdate(this.getSourceCardIndex())) {
                modifier.disable(this.getSourceCardIndex());
                lastState = false;
            }
            if (state == lastState) continue;
            if (state) {
                modifier.enable(this.getSourceCardIndex());
                continue;
            }
            modifier.disable(this.getSourceCardIndex());
        }
        this.updatePlayerAttachedState(masterState);
        this.lastMasterState = masterState;
    }

    private void updatePlayerAttachedState(boolean masterState) {
        if (masterState != this.lastMasterState && this.getSourceAttachPlayerRole() != null && this.getSourceAttachAbility().getTotalNestedAbilityDescriptions() > 0) {
            FX.run(() -> {
                FieldZoneAttachedAbilitiesIndicator indicator = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.getSourceAttachPlayerRole()).getLRIGZone().getZoneAttachedAbilitiesIndicator();
                if (masterState) {
                    indicator.addAbility(this);
                } else {
                    indicator.removeAbility(this);
                }
            });
        }
    }

    @Override
    public void enable() {
        if (this.internalEnable()) {
            this.update();
        }
    }

    @Override
    public void disable() {
        Arrays.stream(this.listModifiers).filter(modifier -> modifier.getLastState(this.getSourceCardIndex())).forEach(modifier -> modifier.disable(this.getSourceCardIndex()));
        this.updatePlayerAttachedState(false);
        this.internalDisable();
    }

    private boolean getState() {
        return this.isTransientEnabled() && !this.isMuted() && this.getSourceCardIndex().isFaceUp() && (!this.isBonded() || this.getSourceCardIndex().getIndexedInstance().hasActiveBond()) && this.isInActiveLocation() && this.getConditionState(this.getSourceCardIndex()) != AbilityCondition.ConditionState.BAD;
    }

    protected boolean isTransientEnabled() {
        return !this.isDisabled() || this.getSourceCardIndex().getIndexedInstance() != null && this.getSourceCardIndex().getIndexedInstance().isState(2048) && (this.getSourceAttachAbility() == null || !this.getSourceAttachAbility().isDisabled() || this.getSourceAttachAbility().getSourceCardIndex() != this.getSourceCardIndex());
    }

    protected final void updateLastEnabledTimestamp() {
        this.lastEnabledTimestamp = Instant.now().toEpochMilli();
    }

    public final long getLastEnabledTimestamp() {
        return this.lastEnabledTimestamp;
    }

    protected final ConstantModifier[] getListModifiers() {
        return this.listModifiers;
    }

    @Override
    public void dispose() {
        if (this.listModifiers != null) {
            for (ConstantModifier listModifier : this.listModifiers) {
                listModifier.dispose();
            }
            this.listModifiers = null;
        }
        super.dispose();
    }
}

