/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.data.Card;
import open.batoru.data.ability.AbilityCondition;
import open.batoru.data.ability.ConstantAbility;
import open.batoru.data.ability.modifiers.ConstantModifier;
import open.batoru.game.FieldData;
import open.batoru.game.FieldZone;
import open.batoru.game.Zone;
import open.batoru.game._3d.Card3D;

public class ConstantAbilityShared
extends ConstantAbility {
    private TargetFilter filter;
    private final List<CardIndex> listFilterTargets = Collections.synchronizedList(new ArrayList());
    private final Map<CardIndex, TrackedCardData> mapTrackedFilterTargets = new ConcurrentHashMap<CardIndex, TrackedCardData>();
    private boolean mustUpdateLastEnabledTimestamp = true;

    public ConstantAbilityShared(TargetFilter filter, ConstantModifier ... listModifiers) {
        super(listModifiers);
        this.filter = filter;
    }

    @Override
    public void setModifiersSourceAbility() {
        super.setModifiersSourceAbility();
        this.filter.setSourceAbility(this);
    }

    @Override
    public void update() {
        this.updateTargets();
        if (this.mustUpdateLastEnabledTimestamp) {
            this.updateLastEnabledTimestamp();
            this.mustUpdateLastEnabledTimestamp = false;
        }
        for (CardIndex cardIndex : this.listFilterTargets) {
            boolean masterState = this.getState(cardIndex);
            TrackedCardData data = this.mapTrackedFilterTargets.computeIfAbsent(cardIndex, k -> new TrackedCardData(false, cardIndex.getLocation(), cardIndex.getIndexedInstance()));
            for (int i = 0; i < this.getListModifiers().length; ++i) {
                boolean state = masterState && this.getListModifiers()[i].getCondition().getState(cardIndex) != AbilityCondition.ConditionState.BAD;
                boolean lastState = data.lastState;
                if (state && lastState && (this.getListModifiers()[i].shouldForceUpdate(cardIndex) || cardIndex.getLocation() != data.lastLocation || cardIndex.getIndexedInstance() != data.lastIndexedInstance)) {
                    this.getListModifiers()[i].disable(cardIndex);
                    lastState = false;
                }
                if (state == lastState) continue;
                if (state) {
                    this.getListModifiers()[i].enable(cardIndex);
                    continue;
                }
                this.getListModifiers()[i].disable(cardIndex);
            }
            data.lastState = masterState;
            data.lastLocation = cardIndex.getLocation();
            data.lastIndexedInstance = cardIndex.getIndexedInstance();
        }
    }

    private void updateTargets() {
        this.listFilterTargets.clear();
        if ((this.filter.getHintOwnerFlags() & 1) != 0) {
            this.gatherTargetsByRole(this.filter.getSourceTargetRole());
        }
        if ((this.filter.getHintOwnerFlags() & 2) != 0) {
            this.gatherTargetsByRole(Game.GamePlayerRole.getOpponentRole(this.filter.getSourceTargetRole()));
        }
        for (CardIndex cardIndex : this.mapTrackedFilterTargets.keySet()) {
            if (this.listFilterTargets.contains(cardIndex) && !cardIndex.getSourceCard3D().shouldClearImageSet()) continue;
            for (int i = 0; i < this.getListModifiers().length; ++i) {
                if (!this.getListModifiers()[i].getLastState(cardIndex)) continue;
                this.getListModifiers()[i].disable(cardIndex);
            }
        }
        this.mapTrackedFilterTargets.keySet().retainAll(this.listFilterTargets);
    }

    private void gatherTargetsByRole(Game.GamePlayerRole rolePlayer) {
        for (GameConst.CardLocation location : this.filter.getHintLocationsData()) {
            Zone zone = FieldData.getZoneByLocation(rolePlayer, location);
            if (zone == null || zone.getZoneCardList().isEmpty()) continue;
            if (GameConst.CardLocation.isSIGNI(location)) {
                FieldZone zoneField = (FieldZone)zone;
                if (this.filter.getTargetContext() == TargetFilter.TargetContext.CARD && (!FieldZone.isOccupied(zoneField) || !this.filter.isPickValid(zoneField.getTopCard())) || this.filter.getTargetContext() == TargetFilter.TargetContext.ZONE && !this.filter.isPickValid(zoneField)) continue;
                this.listFilterTargets.add(zoneField.getTopCard().getCardIndex());
                continue;
            }
            for (int i = 0; i < zone.getTotalCards(); ++i) {
                Card3D card3D = zone.getZoneCardList().get(i);
                if (this.filter.getTargetContext() == TargetFilter.TargetContext.CARD && (card3D.getCardIndex().getIndexedInstance() == null || !this.filter.isPickValid(card3D)) || this.filter.getTargetContext() == TargetFilter.TargetContext.ZONE && zone instanceof FieldZone && !this.filter.isPickValid((FieldZone)zone)) continue;
                this.listFilterTargets.add(card3D.getCardIndex());
            }
        }
    }

    @Override
    public void enable() {
        this.mustUpdateLastEnabledTimestamp = true;
        super.enable();
    }

    @Override
    public void disable() {
        this.updateTargets();
        for (Map.Entry<CardIndex, TrackedCardData> entry : this.mapTrackedFilterTargets.entrySet()) {
            CardIndex cardIndex = entry.getKey();
            TrackedCardData data = entry.getValue();
            if (!data.lastState) continue;
            for (int i = 0; i < this.getListModifiers().length; ++i) {
                if (!this.getListModifiers()[i].getLastState(cardIndex)) continue;
                this.getListModifiers()[i].disable(cardIndex);
            }
            data.lastState = false;
        }
        this.internalDisable();
    }

    private boolean getState(CardIndex cardIndex) {
        return this.isTransientEnabled() && !this.isMuted() && this.getSourceCardIndex().isFaceUp() && (!this.isBonded() || this.getSourceCardIndex().getIndexedInstance().hasActiveBond()) && cardIndex.isFaceUp() && this.isInActiveLocation() && this.getConditionState(cardIndex) != AbilityCondition.ConditionState.BAD && cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_AFFECTED).check(cardIndex, this, new Object[0]) == RuleCheck.RuleCheckState.OK;
    }

    public List<CardIndex> getCachedTargetsList() {
        return List.copyOf(this.listFilterTargets);
    }

    @Override
    public void dispose() {
        this.filter = null;
        this.listFilterTargets.clear();
        this.mapTrackedFilterTargets.clear();
        super.dispose();
    }

    private static class TrackedCardData {
        private boolean lastState;
        private GameConst.CardLocation lastLocation;
        private Card.IndexedInstance lastIndexedInstance;

        public TrackedCardData(boolean state, GameConst.CardLocation location, Card.IndexedInstance indexedInstance) {
            this.lastState = state;
            this.lastLocation = location;
            this.lastIndexedInstance = indexedInstance;
        }
    }
}

