/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndexSnapshot;
import open.batoru.core.gameplay.ChronoDuration;
import open.batoru.core.gameplay.ChronoRecordScheduler;
import open.batoru.core.gameplay.GameConst;
import open.batoru.data.CardConst;
import open.batoru.data.ability.CardSnapshotFunctionalConditionalHandler;
import open.batoru.game.gfx.GFX;
import open.batoru.game.gfx.GFXZoneWall;

public class DamageBlockParams {
    private ChronoRecordScheduler.ChronoRecord record;
    private Function<Game.GamePlayerRole, GFXZoneWall> functionGFX;
    private BooleanSupplier conditionExpire;
    private CardSnapshotFunctionalConditionalHandler conditionSource;
    private Runnable handlerOnDamageBlocked;

    public DamageBlockParams withDuration(ChronoDuration duration) {
        return this.withDuration(new ChronoRecordScheduler.ChronoRecord(duration));
    }

    public DamageBlockParams withDuration(ChronoRecordScheduler.ChronoRecord record) {
        this.record = record;
        return this;
    }

    public DamageBlockParams withInstances(int instances) {
        AtomicInteger count = new AtomicInteger();
        return this.expireWhen(() -> count.incrementAndGet() == instances);
    }

    public DamageBlockParams withGFX(String textureName, int[] colorRGB) {
        this.functionGFX = rolePlayer -> new GFXZoneWall((Game.GamePlayerRole)((Object)rolePlayer), GameConst.CardLocation.LIFE_CLOTH, textureName, colorRGB);
        return this;
    }

    public DamageBlockParams expireWhen(BooleanSupplier conditionExpire) {
        this.conditionExpire = conditionExpire;
        return this;
    }

    public DamageBlockParams blockIf(CardSnapshotFunctionalConditionalHandler conditionSource) {
        this.conditionSource = conditionSource;
        return this;
    }

    public DamageBlockParams whenBlocked(Runnable handlerOnDamageBlocked) {
        this.handlerOnDamageBlocked = handlerOnDamageBlocked;
        return this;
    }

    public GFX getGFX(Game.GamePlayerRole rolePlayer) {
        return this.functionGFX == null ? null : (GFX)this.functionGFX.apply(rolePlayer);
    }

    public ChronoRecordScheduler.ChronoRecord getDuration() {
        return this.record != null ? this.record : new ChronoRecordScheduler.ChronoRecord(ChronoDuration.turnEnd());
    }

    public boolean shouldBlockDamage(CardIndexSnapshot source) {
        return this.conditionSource == null || this.conditionSource.check(source);
    }

    public boolean shouldExpire() {
        return this.conditionExpire == null || this.conditionExpire.getAsBoolean();
    }

    public void callOnDamageBlocked() {
        if (this.handlerOnDamageBlocked != null) {
            this.handlerOnDamageBlocked.run();
        }
    }

    public static DamageBlockParams ofSIGNI() {
        return new DamageBlockParams().blockIf(source -> CardConst.CardType.isSIGNI(source.getCardReference().getType())).withGFX("SIGNI", new int[]{50, 205, 100});
    }

    public static DamageBlockParams ofLRIG() {
        return new DamageBlockParams().blockIf(source -> CardConst.CardType.isLRIG(source.getCardReference().getType())).withGFX("LRIG", new int[]{100, 205, 100});
    }
}

