/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability;

import open.batoru.catalog.description.DescriptionParser;
import open.batoru.data.ModifiableInteger;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.ModalChoiceRepeatTracker;

public class ModalAbility
extends Ability {
    private ModifiableInteger minPicks;
    private ModifiableInteger maxPicks;
    private ModalChoiceRepeatTracker repeatChoiceTracker;
    private int chosenModes;
    private ModalFunctionalHandler handlerOnModesChosenPre;

    public void setModeChoice(int minPicks) {
        this.setModeChoice(minPicks, minPicks);
    }

    public void setModeChoice(int minPicks, int maxPicks) {
        if (this.minPicks == null) {
            this.minPicks = new ModifiableInteger(minPicks);
        } else {
            this.minPicks.setBaseValue(minPicks);
        }
        if (this.maxPicks == null) {
            this.maxPicks = new ModifiableInteger(maxPicks);
        } else {
            this.maxPicks.setBaseValue(maxPicks);
        }
    }

    public void setModeChoiceAllowRepeat(boolean set) {
        this.repeatChoiceTracker = set ? new ModalChoiceRepeatTracker() : null;
    }

    public ModalChoiceRepeatTracker getModalChoiceRepeatTracker() {
        return this.repeatChoiceTracker;
    }

    public void setOnModesChosenPre(ModalFunctionalHandler handleOnModesChosenPre) {
        this.handlerOnModesChosenPre = handleOnModesChosenPre;
    }

    public void onModesChosenPre() {
        if (this.handlerOnModesChosenPre != null) {
            this.handlerOnModesChosenPre.handle();
        }
        if (this.repeatChoiceTracker != null) {
            this.repeatChoiceTracker.prepareAvailableChoices(this.getTotalModalChoices());
        }
    }

    private int getTotalModalChoices() {
        String description = DescriptionParser.getAbilityDescription(this);
        int count = 0;
        int index = 0;
        while ((index = description.indexOf("$$", index)) != -1) {
            ++count;
            index += 2;
        }
        return count;
    }

    public void callRepeatChoice(int bitsChosenMode, ModalFunctionalHandler repeatableAction) {
        if (bitsChosenMode <= 0 || this.repeatChoiceTracker == null) {
            repeatableAction.handle();
            return;
        }
        int bits = Integer.numberOfTrailingZeros(bitsChosenMode);
        if (bits >= this.repeatChoiceTracker.getAvailableChoices()) {
            return;
        }
        for (int i = 0; i < 1 + this.repeatChoiceTracker.getChoiceRepeats(bits); ++i) {
            repeatableAction.handle();
        }
    }

    @Override
    public void resetFlags() {
        super.resetFlags();
        if (this.minPicks != null) {
            this.minPicks.resetValue();
        }
        if (this.maxPicks != null) {
            this.maxPicks.resetValue();
        }
    }

    public ModifiableInteger getModeChoiceMinPicks() {
        return this.minPicks;
    }

    public ModifiableInteger getModeChoiceMaxPicks() {
        return this.maxPicks;
    }

    public void setChosenModes(int modes) {
        this.chosenModes = modes;
    }

    public int getChosenModes() {
        return this.chosenModes;
    }

    @Override
    public void dispose() {
        this.minPicks = null;
        this.maxPicks = null;
        this.repeatChoiceTracker = null;
        this.handlerOnModesChosenPre = null;
        super.dispose();
    }

    @FunctionalInterface
    public static interface ModalFunctionalHandler {
        public void handle();
    }
}

