/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability;

public class ModalChoiceRepeatTracker {
    private int[] chosenRepeatCount;

    public void prepareAvailableChoices(int totalChoices) {
        this.chosenRepeatCount = new int[totalChoices];
    }

    public int getAvailableChoices() {
        return this.chosenRepeatCount.length;
    }

    public void incrementChoiceRepeats(int modeId, int delta) {
        int n = modeId;
        this.chosenRepeatCount[n] = this.chosenRepeatCount[n] + delta;
    }

    public int getChoiceRepeats(int modeId) {
        return this.chosenRepeatCount[modeId];
    }

    public String exportChoiceRepeatsData() {
        StringBuilder data = new StringBuilder();
        for (int i = 0; i < this.chosenRepeatCount.length; ++i) {
            if (this.chosenRepeatCount[i] <= 0) continue;
            data.append("|").append(i).append("|").append(this.chosenRepeatCount[i]);
        }
        return data.toString();
    }
}

