/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability;

import java.util.Optional;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.ActionExclude;
import open.batoru.data.ability.AbilityEffectNoSource;
import open.batoru.data.ability.CheckZoneAbility;

public class PieceAbility
extends CheckZoneAbility {
    private boolean canUseWithoutAssists;

    public PieceAbility(AbilityEffectNoSource effect) {
        this(null, effect);
    }

    public PieceAbility(CheckZoneAbility.CheckZoneFunctionalHandler handlerPreTarget, AbilityEffectNoSource effect) {
        super(handlerPreTarget, effect);
        this.setActiveEvent(GameConst.GameEventId.USE_PIECE);
    }

    public void setCanUseWithoutAssists(boolean set) {
        this.canUseWithoutAssists = set;
    }

    public boolean canUseWithoutAssists() {
        return this.canUseWithoutAssists;
    }

    @Override
    public void onAbilityInit() {
        this.setActiveUseTiming(this.getSourceCardIndex().getIndexedInstance().getUseTimingFlags().getValue());
        super.onAbilityInit();
    }

    @Override
    public void onAbilityEnd(boolean wasResolved) {
        if (this.getSourceCardIndex().getLocation() == GameConst.CardLocation.CHECK_ZONE) {
            Game.getCurrentGame().getActionQueue().addAction(new ActionExclude(this.getSourceCardIndex()));
        }
        super.onAbilityEnd(wasResolved);
    }

    public static Optional<PieceAbility> findPieceAbility(CardIndex cardIndex) {
        return cardIndex.getIndexedInstance().getAbilityList().stream().filter(PieceAbility.class::isInstance).findFirst().map(PieceAbility.class::cast);
    }
}

