/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability;

import java.util.Optional;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.ActionExclude;
import open.batoru.core.gameplay.actions.ActionTrash;
import open.batoru.data.ability.AbilityEffectNoSource;
import open.batoru.data.ability.CheckZoneAbility;

public class SpellAbility
extends CheckZoneAbility {
    public SpellAbility(AbilityEffectNoSource effect) {
        this(null, effect);
    }

    public SpellAbility(CheckZoneAbility.CheckZoneFunctionalHandler handlerPreTarget, AbilityEffectNoSource effect) {
        super(handlerPreTarget, effect);
        this.setActiveEvent(GameConst.GameEventId.USE_SPELL);
    }

    @Override
    public void onAbilityEnd(boolean wasResolved) {
        if (this.getSourceCardIndex().getLocation() == GameConst.CardLocation.CHECK_ZONE) {
            if (!this.getSourceCardIndex().getIndexedInstance().isState(8)) {
                ActionTrash action = new ActionTrash(this.getSourceCardIndex());
                if (this.getSourceCardIndex().getIndexedInstance().isState(512)) {
                    action.setOnActionCompleted(() -> this.getSourceCardIndex().getIndexedInstance().getCardStateFlags().removeValue(512));
                }
                Game.getCurrentGame().getActionQueue().addAction(action);
            } else {
                Game.getCurrentGame().getActionQueue().addAction(new ActionExclude(this.getSourceCardIndex()));
            }
        } else if (this.getSourceCardIndex().getIndexedInstance().isState(512)) {
            this.getSourceCardIndex().getIndexedInstance().getCardStateFlags().removeValue(512);
        }
        super.onAbilityEnd(wasResolved);
    }

    @Override
    public void onAbilityInit() {
        if (this.getSourceCardIndex().getCardReference().isCraft()) {
            this.setActiveUseTiming(this.getSourceCardIndex().getIndexedInstance().getUseTimingFlags().getValue());
        }
        super.onAbilityInit();
    }

    public static Optional<SpellAbility> findSpellAbility(CardIndex cardIndex) {
        return cardIndex.getIndexedInstance().getAbilityList().stream().filter(SpellAbility.class::isInstance).findFirst().map(SpellAbility.class::cast);
    }
}

