/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability.cost;

import open.batoru.Log;
import open.batoru.core.Disposable;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.CardIndexSnapshot;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.actions.ActionEmpty;
import open.batoru.core.gameplay.actions.ActionPayCost;
import open.batoru.core.gameplay.pickers.ConditionHandler;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.data.DataTable;
import open.batoru.data.ModifiableInteger;
import open.batoru.data.ModifiableVariable;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.AbilityConst;
import open.batoru.data.ability.AbilityCostList;
import open.batoru.data.ability.CardFunctionalConditionalHandler;

public abstract class AbilityCost
implements Disposable {
    private boolean isFailed;
    private Ability sourceAbility;
    private CardIndex sourceCardIndex;
    private AbilityCostList sourceCostList;
    private boolean isEffect;
    private Boolean forcedMandatoryState;
    private boolean isSelfCost;
    private boolean isAddedCost;
    private Game.GamePlayerRole rolePayer;
    private final DataTable<Payable> dataPaid = new DataTable();
    private TargetFilter filter;
    private ConditionHandler<CardIndex> condition;
    private Boolean canBePaidPrivately;
    private final ModifiableInteger countMin;
    private final ModifiableInteger countMax;
    private AbilityConst.ChoiceLogic choiceLogic = AbilityConst.ChoiceLogic.DEFAULT;
    private ModifiableVariable.ExternalValue<Integer> externalDynamicValue;
    private static ActionPayCost callbackAction;

    public AbilityCost(int countMin, int countMax, TargetFilter filter, ConditionHandler<CardIndex> condition) {
        this.countMin = new ModifiableInteger(countMin);
        this.countMax = new ModifiableInteger(countMax);
        this.filter = filter != null ? filter.own() : null;
        this.condition = condition;
    }

    public AbilityCost(ModifiableVariable.ExternalValue<Integer> externalDynamicValue, TargetFilter filter) {
        this(0, 0, filter, null);
        this.externalDynamicValue = externalDynamicValue;
        this.countMin.addExternalValue(externalDynamicValue);
        this.countMax.addExternalValue(externalDynamicValue);
    }

    public AbilityCost() {
        this(1, 1, null, null);
        this.isSelfCost = true;
    }

    final void addCustomFilterCheck(CardFunctionalConditionalHandler handler) {
        this.filter = this.filter.custom(handler);
    }

    @Deprecated
    final void updateExternalDynamicValue(ModifiableVariable.ExternalValue<Integer> externalDynamicValue) {
        this.countMin.removeExternalValue(this.externalDynamicValue);
        this.countMax.removeExternalValue(this.externalDynamicValue);
        this.countMin.addExternalValue(externalDynamicValue);
        this.countMax.addExternalValue(externalDynamicValue);
        this.externalDynamicValue = externalDynamicValue;
    }

    public final void setChoiceLogic(AbilityConst.ChoiceLogic choiceLogic) {
        this.choiceLogic = choiceLogic;
    }

    public final AbilityConst.ChoiceLogic getChoiceLogic() {
        return this.choiceLogic;
    }

    public static void setCallbackAction(ActionPayCost action) {
        callbackAction = action;
        Log.printMessage(">>>CB: SET!!! " + String.valueOf(callbackAction));
    }

    public static ActionPayCost getCallbackAction() {
        return callbackAction;
    }

    protected final void addAction(GameAction<?> action) {
        if (this.isFailed) {
            return;
        }
        action.setSourceAbility(this.sourceAbility);
        action.setSourceCardIndex(this.getSourceCardIndex());
        action.setSourceCost(this);
        action.treatAsMidEffAction();
        action.setCallbackAction(callbackAction);
        Game.getCurrentGame().getActionQueue().addAction(action);
        if (action.isBlocked() && action.getSourceOverrideResult() != null) {
            action.getSourceOverrideResult().execThreadedActionOverride(callbackAction);
        }
        if (!action.isSuccessful()) {
            this.isFailed = true;
        }
    }

    public void treatAsEffect() {
        this.isEffect = true;
    }

    public void setForcedMandatoryState(Boolean state) {
        this.forcedMandatoryState = state;
    }

    public boolean isEffect() {
        return this.isEffect;
    }

    public boolean checkForcedMandatoryState(boolean state) {
        return this.forcedMandatoryState != null && this.forcedMandatoryState == state;
    }

    public void setIsAddedCost() {
        this.isAddedCost = true;
    }

    public boolean isAddedCost() {
        return this.isAddedCost;
    }

    public boolean isSelfCost() {
        return this.isSelfCost;
    }

    public void setSourceAbility(Ability ability) {
        this.sourceAbility = ability;
        if (this.filter != null) {
            this.filter.setSourceAbility(ability);
        }
    }

    public Ability getSourceAbility() {
        return this.sourceAbility;
    }

    public void setSourceCardIndex(CardIndex cardIndex) {
        this.sourceCardIndex = cardIndex;
        if (cardIndex != null && this.filter != null) {
            this.filter.setSourceCardIndex(cardIndex);
        }
    }

    public CardIndex getSourceCardIndex() {
        return this.sourceCardIndex == null ? this.sourceAbility.getSourceCardIndex() : this.sourceCardIndex;
    }

    public void setPayerRole(Game.GamePlayerRole rolePlayer) {
        this.rolePayer = rolePlayer;
        if (this.filter != null) {
            this.filter.setTargetRole(rolePlayer);
        }
    }

    public Game.GamePlayerRole getPayerRole() {
        return this.rolePayer == null ? this.getSourceCardIndex().getIndexedInstance().getCurrentOwner() : this.rolePayer;
    }

    public void setSourceCostList(AbilityCostList costList) {
        this.sourceCostList = costList;
    }

    public AbilityCostList getSourceCostList() {
        return this.sourceCostList;
    }

    public boolean isPrecededByBaseCost() {
        return this.sourceCostList != null && this.sourceCostList.getDataArray().getFirst() != this && !this.sourceCostList.getDataArray().get(this.sourceCostList.getDataArray().indexOf(this) - 1).isAddedCost();
    }

    public ModifiableInteger getModifiableCostMinCount() {
        return this.countMin;
    }

    public ModifiableInteger getModifiableCostMaxCount() {
        return this.countMax;
    }

    public int getCostMinCount() {
        return this.countMin.getValue();
    }

    public int getCostMaxCount() {
        return this.countMax.getValue();
    }

    public final DataTable<Payable> getPaidCostData() {
        return this.dataPaid;
    }

    public final boolean hasDynamicCost() {
        return this.countMin.hasExternalValue();
    }

    public final void internalPay() {
        this.isFailed = false;
        if (!this.hasDynamicCost() || this.getCostMinCount() > 0 || this.getCostMaxCount() > 0) {
            this.pay();
        } else {
            this.addPaidData(new EmptyPayable());
            ActionEmpty actionEmpty = new ActionEmpty();
            actionEmpty.getDataTable().add(this.getSourceCardIndex());
            this.addAction(actionEmpty);
        }
        if (!this.isPaid()) {
            this.dataPaid.clear();
        }
        if (this.sourceCostList != null) {
            this.sourceCostList.markCostAsCompleted(this);
        }
    }

    public abstract boolean canBePaid();

    protected abstract void pay();

    public final Boolean getCanBePaidPrivately() {
        return this.canBePaidPrivately;
    }

    public final void setCanBePaidPrivately(Boolean set) {
        this.canBePaidPrivately = set;
    }

    public boolean isVisuallySignificant() {
        return !this.isSelfCost() || this.hasDynamicCost();
    }

    public final boolean isPaid() {
        return !this.isFailed && !this.dataPaid.isEmpty() && this.dataPaid.get() != null;
    }

    @Deprecated
    public boolean canBePaidWithResult() {
        return this.canBePaid();
    }

    @Deprecated
    public int getPaidNumWithResult() {
        return this.dataPaid.size();
    }

    public final TargetFilter getFilter() {
        return this.filter;
    }

    public final ConditionHandler<CardIndex> getCondition() {
        return this.condition;
    }

    public TargetFilter.TargetHint getDefaultTargetHintType() {
        return TargetFilter.TargetHint.GENERIC;
    }

    public void addPaidCardIndexData(CardIndex cardIndex) {
        this.addPaidData(cardIndex != null ? new CardIndexSnapshot(cardIndex) : null);
    }

    public void addPaidData(Payable payable) {
        this.dataPaid.add(payable);
        if (this.sourceCostList != null) {
            this.sourceCostList.getPaidCostData().add(payable);
        }
    }

    @Override
    public void dispose() {
        this.sourceAbility = null;
        this.sourceCardIndex = null;
        this.sourceCostList = null;
        this.dataPaid.clear();
        this.filter = null;
        this.condition = null;
    }

    public static class EmptyPayable
    implements Payable {
    }

    public static interface Payable {
    }
}

