/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability.cost;

import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.actions.ActionBanish;
import open.batoru.core.gameplay.actions.ActionManualTargetCard;
import open.batoru.core.gameplay.actions.ActionPlayerChoiceCard;
import open.batoru.core.gameplay.control.PlayerControl;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.data.ability.AbilityConst;
import open.batoru.data.ability.cost.AbilityCost;

public class BanishCost
extends AbilityCost {
    public BanishCost(TargetFilter filter) {
        super(1, 1, filter.SIGNI(), null);
    }

    @Override
    public boolean canBePaid() {
        return this.getFilter().getValidTargetsCount() >= this.getCostMinCount();
    }

    @Override
    protected void pay() {
        GameAction action = PlayerControl.isChoosingPlayer(this.getPayerRole()) ? new ActionManualTargetCard(this.getCostMinCount(), this.getCostMaxCount(), this.getFilter(), this.getCondition(), AbilityConst.ChoiceLogic.DEFAULT) : new ActionPlayerChoiceCard(this.getFilter());
        this.addAction(action);
        if (action.getDataTable().get() != null) {
            ActionBanish prevAction = null;
            for (int i = 0; i < action.getDataTable().size(); ++i) {
                ActionBanish actionBanish = new ActionBanish((CardIndex)action.getDataTable().get(i));
                actionBanish.setAtOnce(prevAction, i, action.getDataTable().size());
                prevAction = actionBanish;
                this.addAction(actionBanish);
            }
        }
    }

    @Override
    public TargetFilter.TargetHint getDefaultTargetHintType() {
        return TargetFilter.TargetHint.BANISH;
    }
}

