/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability.cost;

import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.actions.ActionExceed;
import open.batoru.core.gameplay.actions.ActionManualExceed;
import open.batoru.core.gameplay.control.PlayerControl;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.game.FieldZone;
import open.batoru.game.PlayerField;
import open.batoru.ui.UI;

public class ExceedCost
extends AbilityCost {
    public ExceedCost(int count) {
        super(count, count, null, null);
    }

    @Override
    public boolean canBePaid() {
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.getPayerRole());
        int numExceedable = field.getLRIGZone().getTotalCards() - 1;
        if (FieldZone.isOccupied(field.getLRIGAssistZoneLeft())) {
            numExceedable += field.getLRIGAssistZoneLeft().getTotalCards() - 1;
        }
        if (FieldZone.isOccupied(field.getLRIGAssistZoneRight())) {
            numExceedable += field.getLRIGAssistZoneRight().getTotalCards() - 1;
        }
        return numExceedable >= this.getCostMinCount();
    }

    @Override
    protected void pay() {
        GameAction action = PlayerControl.isChoosingPlayer(this.getPayerRole()) ? new ActionManualExceed(this.isEffect(), this.getCostMinCount()) : new ActionExceed();
        this.addAction(action);
    }

    @Override
    public TargetFilter.TargetHint getDefaultTargetHintType() {
        return TargetFilter.TargetHint.TRASH;
    }
}

