/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability.cost;

import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.ActionExclude;
import open.batoru.core.gameplay.actions.ActionManualSearchDeck;
import open.batoru.core.gameplay.actions.ActionManualTargetCard;
import open.batoru.core.gameplay.actions.ActionPlayerChoiceCard;
import open.batoru.core.gameplay.control.PlayerControl;
import open.batoru.core.gameplay.pickers.ConditionHandler;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.data.ability.AbilityConst;
import open.batoru.data.ability.cost.AbilityCost;

public class ExcludeCost
extends AbilityCost {
    public ExcludeCost() {
    }

    public ExcludeCost(TargetFilter filter) {
        super(1, 1, filter, null);
    }

    public ExcludeCost(int countMin, TargetFilter filter) {
        super(countMin, countMin, filter, null);
    }

    public ExcludeCost(int countMin, int countMax, TargetFilter filter) {
        super(countMin, countMax, filter, null);
    }

    public ExcludeCost(int countMin, TargetFilter filter, ConditionHandler<CardIndex> condition) {
        super(countMin, countMin, filter, condition);
    }

    public ExcludeCost(int countMin, int countMax, TargetFilter filter, ConditionHandler<CardIndex> condition) {
        super(countMin, countMax, filter, condition);
    }

    @Override
    public boolean canBePaid() {
        return !this.isSelfCost() ? this.getFilter().getValidTargetsCount() >= this.getCostMinCount() : this.getSourceCardIndex().getLocation() != GameConst.CardLocation.EXCLUDED;
    }

    @Override
    protected void pay() {
        if (!this.isSelfCost()) {
            GameAction action;
            if (PlayerControl.isChoosingPlayer(this.getPayerRole())) {
                if (!this.getFilter().getHintLocationsData().contains((Object)GameConst.CardLocation.TRASH) && !this.getFilter().getHintLocationsData().contains((Object)GameConst.CardLocation.TRASH_LRIG)) {
                    action = new ActionManualTargetCard(this.getCostMinCount(), this.getCostMaxCount(), this.getFilter(), this.getCondition(), AbilityConst.ChoiceLogic.DEFAULT);
                } else {
                    GameConst.CardLocation location;
                    if (this.getFilter().getHintLocationsData().contains((Object)GameConst.CardLocation.TRASH)) {
                        location = GameConst.CardLocation.TRASH;
                    } else if (this.getFilter().getHintLocationsData().contains((Object)GameConst.CardLocation.TRASH_LRIG)) {
                        location = GameConst.CardLocation.TRASH_LRIG;
                    } else {
                        throw new IllegalArgumentException();
                    }
                    action = new ActionManualSearchDeck(this.getCostMinCount(), this.getCostMaxCount(), this.getFilter(), this.getCondition(), this.getPayerRole(), location);
                }
            } else {
                action = new ActionPlayerChoiceCard(this.getFilter());
            }
            this.addAction(action);
            if (action.getDataTable().get() != null) {
                ActionExclude prevAction = null;
                for (int i = 0; i < action.getDataTable().size(); ++i) {
                    ActionExclude actionExclude = new ActionExclude((CardIndex)action.getDataTable().get(i));
                    actionExclude.setAtOnce(prevAction, i, action.getDataTable().size());
                    prevAction = actionExclude;
                    this.addAction(actionExclude);
                }
            }
        } else {
            ActionExclude action = new ActionExclude(this.getSourceCardIndex());
            this.addAction(action);
        }
    }

    @Override
    public TargetFilter.TargetHint getDefaultTargetHintType() {
        return TargetFilter.TargetHint.EXCLUDE;
    }
}

