/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability.cost;

import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.ActionAddToHand;
import open.batoru.core.gameplay.actions.ActionManualTargetCard;
import open.batoru.core.gameplay.actions.ActionPlayerChoiceCard;
import open.batoru.core.gameplay.actions.ActionReveal;
import open.batoru.core.gameplay.control.PlayerControl;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.data.ability.AbilityConst;
import open.batoru.data.ability.cost.AbilityCost;

public class RevealCost
extends AbilityCost {
    public RevealCost() {
    }

    public RevealCost(int countMin, TargetFilter filter) {
        super(countMin, countMin, filter, null);
    }

    @Override
    public boolean canBePaid() {
        if (!this.isSelfCost()) {
            if (this.getPayerRole() == Game.getCurrentGame().getPlayerRole() && !Game.getCurrentGame().isNeutralPerspectiveGame()) {
                this.setCanBePaidPrivately(this.getFilter().getValidTargetsCount() >= this.getCostMaxCount());
                return this.getFilter().getTotalTargetsCount() >= this.getCostMaxCount();
            }
            return this.getFilter().getValidTargetsCount() >= this.getCostMaxCount();
        }
        return this.getSourceCardIndex().getLocation() != GameConst.CardLocation.REVEALED;
    }

    @Override
    protected void pay() {
        if (!this.isSelfCost()) {
            GameAction action = PlayerControl.isChoosingPlayer(this.getPayerRole()) ? new ActionManualTargetCard(this.getCostMinCount(), this.getCostMaxCount(), this.getFilter(), this.getCondition(), AbilityConst.ChoiceLogic.DEFAULT) : new ActionPlayerChoiceCard(this.getFilter());
            this.addAction(action);
            if (action.getDataTable().get() != null) {
                ActionReveal prevAction = null;
                for (int i = 0; i < action.getDataTable().size(); ++i) {
                    ActionReveal actionReveal = new ActionReveal((CardIndex)action.getDataTable().get(i), false);
                    actionReveal.setAtOnce(prevAction, i, action.getDataTable().size());
                    prevAction = actionReveal;
                    this.addAction(actionReveal);
                }
                ActionAddToHand prevActionToHand = null;
                for (int i = 0; i < action.getDataTable().size(); ++i) {
                    ActionAddToHand actionAddToHand = new ActionAddToHand((CardIndex)action.getDataTable().get(i));
                    actionAddToHand.setAtOnce(prevActionToHand, i, action.getDataTable().size());
                    prevActionToHand = actionAddToHand;
                    this.addAction(actionAddToHand);
                }
            }
        } else {
            ActionReveal action = new ActionReveal(this.getSourceCardIndex(), false);
            this.addAction(action);
            ActionAddToHand actionToHand = new ActionAddToHand(this.getSourceCardIndex());
            this.addAction(actionToHand);
        }
    }

    @Override
    public TargetFilter.TargetHint getDefaultTargetHintType() {
        return TargetFilter.TargetHint.REVEAL;
    }
}

