/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability.cost;

import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.CardIndexSnapshot;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.ActionManualSearchDeck;
import open.batoru.core.gameplay.actions.ActionManualTargetCard;
import open.batoru.core.gameplay.actions.ActionPlayerChoiceCard;
import open.batoru.core.gameplay.actions.ActionTrash;
import open.batoru.core.gameplay.control.PlayerControl;
import open.batoru.core.gameplay.pickers.ConditionHandler;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.data.ModifiableVariable;
import open.batoru.data.ability.AbilityConst;
import open.batoru.data.ability.CardFunctionalConditionalHandler;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.game.FieldData;
import open.batoru.game._3d.Card3D;

public class TrashCost
extends AbilityCost {
    private final CardFunctionalConditionalHandler handlerRuleCheck = cardIndex -> cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_MOVED).check(cardIndex, this.getSourceCardIndex(), this.getSourceAbility(), new Object[]{Card3D.isMainDeckCard(cardIndex.getSourceCard3D()) ? GameConst.CardLocation.TRASH : GameConst.CardLocation.TRASH_LRIG}) == RuleCheck.RuleCheckState.OK;
    private GameConst.CardLocation location;

    public TrashCost() {
    }

    public TrashCost(GameConst.CardLocation location) {
        this(1, 1, AbilityConst.ChoiceLogic.DEFAULT, null, null);
        this.location = location;
    }

    public TrashCost(TargetFilter filter) {
        this(1, 1, filter, null);
    }

    public TrashCost(int countMin, TargetFilter filter) {
        this(countMin, countMin, filter, null);
    }

    public TrashCost(int countMin, int countMax, TargetFilter filter) {
        this(countMin, countMax, filter, null);
    }

    public TrashCost(int countMin, TargetFilter filter, ConditionHandler<CardIndex> condition) {
        this(countMin, countMin, filter, condition);
    }

    public TrashCost(int countMin, int countMax, AbilityConst.ChoiceLogic choiceLogic, TargetFilter filter) {
        this(countMin, countMax, choiceLogic, filter, null);
    }

    public TrashCost(int countMin, int countMax, TargetFilter filter, ConditionHandler<CardIndex> condition) {
        this(countMin, countMax, AbilityConst.ChoiceLogic.DEFAULT, filter, condition);
    }

    public TrashCost(int countMin, int countMax, AbilityConst.ChoiceLogic choiceLogic, TargetFilter filter, ConditionHandler<CardIndex> condition) {
        super(countMin, countMax, filter, condition);
        this.setChoiceLogic(choiceLogic);
        if (filter != null) {
            this.addCustomFilterCheck(this.handlerRuleCheck);
        }
    }

    public TrashCost(ModifiableVariable.ExternalValue<Integer> externalDynamicValue, TargetFilter filter) {
        super(externalDynamicValue, filter);
        if (filter != null) {
            this.addCustomFilterCheck(this.handlerRuleCheck);
            if (filter.getHintLocationsData().contains((Object)GameConst.CardLocation.ENER)) {
                this.updateExternalDynamicValue(() -> (Integer)externalDynamicValue.getValue() - this.getSourceCostList().getReservedEnerCount());
            }
        }
    }

    @Override
    public boolean canBePaid() {
        GameConst.CardLocation sourceLocation;
        if (this.getFilter() != null) {
            return this.getFilter().getValidTargetsCount() >= this.getCostMinCount();
        }
        GameConst.CardLocation cardLocation = sourceLocation = this.location == null ? this.getSourceCardIndex().getLocation() : this.location;
        if (sourceLocation == GameConst.CardLocation.TRASH || sourceLocation == GameConst.CardLocation.TRASH_LRIG) {
            return false;
        }
        return this.location == null || FieldData.getZoneByLocation(this.getPayerRole(), this.location).getTotalCards() > 0;
    }

    @Override
    public boolean canBePaidWithResult() {
        return this.canBePaid() && (this.getFilter() == null || (long)this.getFilter().getValidTargetsCount() - this.getFilter().getExportedData(true).stream().filter(c -> ((CardIndex)c).getCardReference().isCraft()).count() >= (long)this.getCostMinCount());
    }

    @Override
    public int getPaidNumWithResult() {
        return this.getPaidCostData().size() - (int)this.getPaidCostData().stream().filter(c -> ((CardIndexSnapshot)c).getSourceCardIndex().getLocation() != GameConst.CardLocation.TRASH && ((CardIndexSnapshot)c).getSourceCardIndex().getLocation() != GameConst.CardLocation.TRASH_LRIG).count();
    }

    @Override
    protected void pay() {
        if (this.getFilter() != null) {
            GameAction action;
            if (PlayerControl.isChoosingPlayer(this.getPayerRole())) {
                int minCount = this.getCostMinCount();
                if (minCount == 0 && (this.checkForcedMandatoryState(true) || this.isPrecededByBaseCost())) {
                    minCount = this.getCostMaxCount();
                }
                action = !this.getFilter().getHintLocationsData().contains((Object)GameConst.CardLocation.DECK_LRIG) ? new ActionManualTargetCard(minCount, this.getCostMaxCount(), this.getFilter(), this.getCondition(), this.getChoiceLogic()) : new ActionManualSearchDeck(minCount, this.getCostMaxCount(), this.getFilter(), this.getCondition(), this.getPayerRole(), GameConst.CardLocation.DECK_LRIG);
            } else {
                action = new ActionPlayerChoiceCard(this.getFilter());
            }
            this.addAction(action);
            if (action.getDataTable().get() != null) {
                ActionTrash prevAction = null;
                for (int i = 0; i < action.getDataTable().size(); ++i) {
                    ActionTrash actionTrash = new ActionTrash((CardIndex)action.getDataTable().get(i));
                    actionTrash.setAtOnce(prevAction, i, action.getDataTable().size());
                    prevAction = actionTrash;
                    this.addAction(actionTrash);
                }
            }
        } else {
            ActionTrash action = this.location == null ? new ActionTrash(this.getSourceCardIndex()) : new ActionTrash();
            this.addAction(action);
        }
    }

    @Override
    public TargetFilter.TargetHint getDefaultTargetHintType() {
        return TargetFilter.TargetHint.TRASH;
    }
}

