/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability.cost;

import java.util.Arrays;
import open.batoru.core.Game;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.ActionManualTargetZone;
import open.batoru.core.gameplay.actions.ActionPlayerChoiceZone;
import open.batoru.core.gameplay.actions.ActionZoneRemoveObject;
import open.batoru.core.gameplay.control.PlayerControl;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.game.FieldStackZone;
import open.batoru.game.PlayerField;
import open.batoru.ui.UI;

public class VirusCost
extends AbilityCost {
    public VirusCost(int countMin) {
        super(countMin, countMin, null, null);
    }

    public VirusCost(int countMin, int countMax) {
        super(countMin, countMax, null, null);
    }

    @Override
    public boolean canBePaid() {
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(Game.GamePlayerRole.getOpponentRole(this.getPayerRole()));
        return Arrays.stream(GameConst.SIGNIZonePosition.values()).filter(zonePosition -> field.getSIGNIZone((GameConst.SIGNIZonePosition)((Object)zonePosition)).hasZoneObject(GameConst.CardUnderType.ZONE_VIRUS)).count() >= (long)this.getCostMinCount();
    }

    @Override
    protected void pay() {
        TargetFilter filter = new TargetFilter().OP().SIGNI().infected();
        filter.setTargetRole(this.getPayerRole());
        GameAction action = PlayerControl.isChoosingPlayer(this.getPayerRole()) ? new ActionManualTargetZone(this.getCostMinCount(), this.getCostMaxCount(), filter, null) : new ActionPlayerChoiceZone(filter);
        this.addAction(action);
        if (action.getDataTable().get() != null) {
            ActionZoneRemoveObject prevAction = null;
            for (int i = 0; i < action.getDataTable().size(); ++i) {
                ActionZoneRemoveObject actionRemove = new ActionZoneRemoveObject((FieldStackZone)action.getDataTable().get(i), GameConst.CardUnderType.ZONE_VIRUS);
                actionRemove.setAtOnce(prevAction, i, action.getDataTable().size());
                prevAction = actionRemove;
                this.addAction(actionRemove);
            }
        }
    }
}

