/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability.events;

import java.util.Objects;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.CardIndexSnapshot;
import open.batoru.core.gameplay.GameAction;
import open.batoru.core.gameplay.GameConst;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.cost.AbilityCost;

public abstract class GameEvent {
    private final GameConst.GameEventId id;
    private final CardIndexSnapshot caller;
    private final CardIndexSnapshot source;
    private final Ability sourceAbility;
    private final AbilityCost sourceCost;
    private GameAction<?> sourceActionDataHolder;
    private int numAtOnce = 1;
    private boolean isFirstAtOnce = true;
    private boolean isLastAtOnce = true;

    public GameEvent(GameConst.GameEventId id, CardIndex caller, CardIndex source, Ability sourceAbility, AbilityCost sourceCost) {
        this.id = id;
        this.caller = caller != null ? new CardIndexSnapshot(caller) : null;
        this.source = source != null ? new CardIndexSnapshot(source) : null;
        this.sourceAbility = sourceAbility;
        this.sourceCost = sourceCost != null && !sourceCost.isEffect() ? sourceCost : null;
    }

    public final GameConst.GameEventId getId() {
        return this.id;
    }

    public final CardIndexSnapshot getCaller() {
        return this.caller;
    }

    public final CardIndexSnapshot getSource() {
        return this.source;
    }

    public final CardIndex getCallerCardIndex() {
        return this.caller != null ? this.caller.getSourceCardIndex() : null;
    }

    public final CardIndex getSourceCardIndex() {
        return this.source != null ? this.source.getSourceCardIndex() : null;
    }

    public final Ability getSourceAbility() {
        return this.sourceAbility;
    }

    public final AbilityCost getSourceCost() {
        return this.sourceCost;
    }

    public void setAtOnce(GameAction<?> sourceActionDataHolder, int numCurrent, int numTotal) {
        this.sourceActionDataHolder = sourceActionDataHolder;
        this.isFirstAtOnce = numCurrent == 0;
        this.isLastAtOnce = numCurrent == numTotal - 1;
    }

    public void setAtOnce(GameAction<?> action) {
        this.numAtOnce = action.getNumAtOnce();
        this.isFirstAtOnce = action.getPrevAtOnceAction() == null;
        this.isLastAtOnce = action.isLastAtOnce();
    }

    public void setAtOnce(int numCurrent, int numTotal) {
        this.numAtOnce = numCurrent + 1;
        this.isFirstAtOnce = numCurrent == 0;
        this.isLastAtOnce = this.numAtOnce == numTotal;
    }

    int getNumAtOnce() {
        return this.sourceActionDataHolder == null ? this.numAtOnce : (int)this.sourceActionDataHolder.getDataTable().stream().filter(Objects::nonNull).count();
    }

    public boolean isFirstAtOnce() {
        return this.isFirstAtOnce;
    }

    public boolean isLastAtOnce() {
        return this.isLastAtOnce;
    }

    public final boolean isAtOnce(int num) {
        return this.isLastAtOnce && this.getNumAtOnce() + 1 >= num;
    }

    public final boolean isExactAtOnce(int num) {
        return this.isLastAtOnce && this.getNumAtOnce() == num;
    }
}

