/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability.events;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import open.batoru.core.Disposable;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.data.DataTable;
import open.batoru.data.ability.events.GameEvent;

public class GameEventAccumulator
implements Disposable {
    private final Map<GameEvent, DataTable<CardIndex>> map = new LinkedHashMap<GameEvent, DataTable<CardIndex>>();
    private DataTable<CardIndex> lastData;
    private GameEvent lastEvent;

    public void process(GameEvent event) {
        int numAtOnce = event.getNumAtOnce();
        if (this.lastEvent == null || numAtOnce <= this.lastEvent.getNumAtOnce()) {
            this.lastData = new DataTable();
        }
        this.lastEvent = event;
        this.lastData.add(event.getCallerCardIndex());
        this.map.put(event, this.lastData);
    }

    public void reset(DataTable<CardIndex> data) {
        this.map.entrySet().removeIf(entry -> entry.getValue() == data);
    }

    public List<GameEvent> getEvents(DataTable<CardIndex> data) {
        return this.map.entrySet().stream().filter(entry -> entry.getValue() == data).map(Map.Entry::getKey).toList();
    }

    public DataTable<CardIndex> getData(GameEvent event) {
        return this.map.get(event);
    }

    @Override
    public void dispose() {
        this.lastData = null;
        this.lastEvent = null;
        this.map.clear();
    }
}

