/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability.modifiers;

import java.util.HashMap;
import java.util.Map;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.modifiers.ConstantModifier;
import open.batoru.data.ability.modifiers.CostModifier;

public class AbilityCostModifier
extends ConstantModifier {
    private SampleAbilityCostHandler handlerSample;
    private CostModifier modifier;
    private final Map<CardIndex, Integer> cacheOldAbilitiesNum = new HashMap<CardIndex, Integer>();

    public AbilityCostModifier(SampleAbilityCostHandler handlerSample, CostModifier modifier) {
        this.handlerSample = handlerSample;
        this.modifier = modifier;
    }

    @Override
    public boolean shouldForceUpdate(CardIndex cardIndex) {
        return cardIndex.getIndexedInstance().getAbilityList().size() != this.cacheOldAbilitiesNum.getOrDefault(cardIndex, 0).intValue();
    }

    @Override
    void internalEnable(CardIndex cardIndex) {
        this.cacheOldAbilitiesNum.put(cardIndex, cardIndex.getIndexedInstance().getAbilityList().size());
        cardIndex.getIndexedInstance().getAbilityList().stream().filter(this.handlerSample::matches).forEach(ability -> this.modifier.modify(ability.getCostLists(), ability.getSourceCardIndex(), (Ability)ability));
    }

    @Override
    void internalDisable(CardIndex cardIndex) {
        this.cacheOldAbilitiesNum.remove(cardIndex);
        cardIndex.getIndexedInstance().getAbilityList().stream().filter(this.handlerSample::matches).forEach(ability -> this.modifier.restore(ability.getCostLists()));
    }

    @Override
    public void dispose() {
        this.handlerSample = null;
        this.modifier.dispose();
        this.modifier = null;
        this.cacheOldAbilitiesNum.clear();
        super.dispose();
    }

    @FunctionalInterface
    public static interface SampleAbilityCostHandler {
        public boolean matches(Ability var1);
    }
}

