/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability.modifiers;

import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.data.DataTable;
import open.batoru.data.ModifiableVariable;
import open.batoru.data.ability.modifiers.ConstantModifier;

public class CardNameModifier
extends ConstantModifier {
    private TargetFilter filter;
    private DataTable<CardIndex> cachedData;
    private int lastSize;
    private ModifiableVariable.ModifiableValueReference<String> valueReference;

    public CardNameModifier(TargetFilter filter) {
        this.filter = filter;
    }

    @Override
    public boolean shouldForceUpdate(CardIndex cardIndex) {
        if (this.lastSize == 0) {
            this.lastSize = this.filter.getExportedData().size();
            return this.lastSize != 0;
        }
        return false;
    }

    @Override
    void internalEnable(CardIndex cardIndex) {
        if (this.cachedData == null) {
            this.cachedData = this.filter.getExportedData();
        }
        if (this.cachedData.isEmpty()) {
            return;
        }
        this.lastSize = this.cachedData.size();
        this.valueReference = cardIndex.getIndexedInstance().getName().addValue(this.cachedData.get().getCardReference().getOriginalName());
    }

    @Override
    void internalDisable(CardIndex cardIndex) {
        if (this.valueReference != null) {
            cardIndex.getIndexedInstance().getName().removeValue(this.valueReference);
        }
    }

    @Override
    public void dispose() {
        this.filter = null;
        this.cachedData = null;
        this.valueReference = null;
        super.dispose();
    }
}

