/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability.modifiers;

import java.util.HashSet;
import java.util.Set;
import open.batoru.core.Disposable;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.data.Token;
import open.batoru.data.ability.AbilityCondition;
import open.batoru.data.ability.AbilityConditionWithSource;
import open.batoru.data.ability.ConstantAbility;

public abstract class ConstantModifier
implements Disposable {
    private ConstantAbility sourceAbility;
    private AbilityCondition condition = AbilityConditionWithSource.ALWAYS_TRUE;
    private final Set<CardIndex> cacheLastState = new HashSet<CardIndex>();
    private int priority;

    public ConstantModifier() {
    }

    public ConstantModifier(AbilityCondition condition) {
        this.condition = condition;
    }

    public void setSourceAbility(ConstantAbility ability) {
        this.sourceAbility = ability;
    }

    public ConstantAbility getSourceAbility() {
        return this.sourceAbility;
    }

    public AbilityCondition getCondition() {
        return this.condition;
    }

    final void increasePriority() {
        ++this.priority;
    }

    final void decreasePriority() {
        --this.priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean shouldForceUpdate(CardIndex cardIndex) {
        return false;
    }

    public final void enable(CardIndex cardIndex) {
        Game.getCurrentGame().getGameData().addToActiveModifiersCache(this);
        this.cacheLastState.add(cardIndex);
        this.internalEnable(cardIndex);
        this.sourceAbility.callOnAbilityEnabledHandler(cardIndex);
    }

    public final void disable(CardIndex cardIndex) {
        Game.getCurrentGame().getGameData().removeFromActiveModifiersCache(this);
        this.cacheLastState.remove(cardIndex);
        if (cardIndex.getIndexedInstance() != null || cardIndex.getCardReference() instanceof Token) {
            this.internalDisable(cardIndex);
        }
        this.sourceAbility.callOnAbilityDisabledHandler(cardIndex);
    }

    public boolean getLastState(CardIndex cardIndex) {
        return this.cacheLastState.contains(cardIndex);
    }

    abstract void internalEnable(CardIndex var1);

    abstract void internalDisable(CardIndex var1);

    @Override
    public void dispose() {
        this.sourceAbility = null;
        this.condition = null;
        this.cacheLastState.clear();
    }
}

