/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability.modifiers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.data.ModifiableVariable;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.AbilityConditionWithSource;
import open.batoru.data.ability.AbilityCostList;
import open.batoru.data.ability.CheckZoneAbility;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.data.ability.cost.AbilityORCost;
import open.batoru.data.ability.cost.EnerCost;
import open.batoru.data.ability.modifiers.ConstantModifier;

public class CostModifier
extends ConstantModifier {
    private SampleCostHandler handlerSample;
    private AbilityCost costSample;
    private final ModifierMode mode;
    private final Map<CardIndex, Integer> cacheOldCostListsNum = new HashMap<CardIndex, Integer>();
    private final Map<AbilityCost, ModifiableVariable.ModifiableValueReference<String>> mapStringValueReferences = new HashMap<AbilityCost, ModifiableVariable.ModifiableValueReference<String>>();
    private final Map<AbilityCost, ModifiableVariable.ModifiableValueReference<Integer>> mapIntegerValueReferences = new HashMap<AbilityCost, ModifiableVariable.ModifiableValueReference<Integer>>();
    private final List<AbilityCost> cacheNewlyAddedCosts = new ArrayList<AbilityCost>();
    private final List<AbilityCost> cacheModifiedCosts = new ArrayList<AbilityCost>();
    private final List<AbilityCostList> cacheNewlyAddedCostLists = new ArrayList<AbilityCostList>();

    public CostModifier(SampleCostHandlerNoSource handlerSample, ModifierMode mode) {
        this(AbilityConditionWithSource.ALWAYS_TRUE, handlerSample, mode);
    }

    public CostModifier(AbilityConditionWithSource condition, SampleCostHandlerNoSource handlerSample, ModifierMode mode) {
        super(condition);
        this.handlerSample = handlerSample;
        this.mode = mode;
    }

    public CostModifier(SampleCostHandlerWithSource handlerSample, ModifierMode mode) {
        this(AbilityConditionWithSource.ALWAYS_TRUE, handlerSample, mode);
    }

    public CostModifier(AbilityConditionWithSource condition, SampleCostHandlerWithSource handlerSample, ModifierMode mode) {
        super(condition);
        this.handlerSample = handlerSample;
        this.mode = mode;
    }

    private AbilityCost getCostSample(CardIndex sourceCardIndex) {
        if (this.costSample == null) {
            this.costSample = this.handlerSample.getCost(sourceCardIndex);
        }
        return this.costSample;
    }

    @Override
    public boolean shouldForceUpdate(CardIndex cardIndex) {
        return cardIndex.getIndexedInstance().getCost().size() != this.cacheOldCostListsNum.getOrDefault(cardIndex, 0).intValue();
    }

    @Override
    void internalEnable(CardIndex cardIndex) {
        this.cacheOldCostListsNum.put(cardIndex, cardIndex.getIndexedInstance().getCost().size());
        this.modify(cardIndex.getIndexedInstance().getCost(), cardIndex, null);
    }

    @Override
    void internalDisable(CardIndex cardIndex) {
        this.cacheOldCostListsNum.remove(cardIndex);
        this.restore(cardIndex.getIndexedInstance().getCost());
    }

    public void modify(List<AbilityCostList> dataCostLists, CardIndex sourceCardIndex, Ability sourceAbility) {
        if (this.mode != ModifierMode.ALTERNATIVE) {
            boolean found = false;
            for (AbilityCostList costList : dataCostLists) {
                for (AbilityCost cost : costList.getDataArray()) {
                    if (!cost.getClass().equals(this.getCostSample(sourceCardIndex).getClass()) || this.cacheNewlyAddedCosts.contains(cost)) continue;
                    found = true;
                    this.modifyExistingCost(cost);
                }
            }
            if (!found && this.mode == ModifierMode.INCREASE) {
                this.addNewCost(dataCostLists, sourceCardIndex, sourceAbility);
            }
        } else {
            this.addAlternativeCost(dataCostLists, sourceCardIndex, sourceAbility);
        }
    }

    private void modifyExistingCost(AbilityCost cost) {
        if (cost instanceof EnerCost) {
            EnerCost enerCost = (EnerCost)cost;
            String sampleCostString = ((EnerCost)this.getCostSample(cost.getSourceCardIndex())).getCostString().getValue();
            this.mapStringValueReferences.put(enerCost, switch (this.mode.ordinal()) {
                case 0 -> enerCost.getCostString().addValue(sampleCostString);
                case 1 -> enerCost.getCostString().removeValue(sampleCostString);
                case 2 -> enerCost.getCostString().setBaseValue(sampleCostString);
                default -> new ModifiableVariable.ModifiableValueReference<String>(enerCost.getCostString().getValue());
            });
            if (this.shouldModifyCardDescription(enerCost)) {
                cost.getSourceAbility().addEnerCostDescriptionModifier();
            }
        } else {
            int sampleCostInteger = this.getCostSample(cost.getSourceCardIndex()).getCostMinCount();
            this.mapIntegerValueReferences.put(cost, switch (this.mode.ordinal()) {
                case 0 -> cost.getModifiableCostMinCount().addValue(sampleCostInteger);
                case 1 -> cost.getModifiableCostMinCount().addValue(-sampleCostInteger);
                case 2 -> cost.getModifiableCostMinCount().setBaseValue(sampleCostInteger);
                default -> new ModifiableVariable.ModifiableValueReference<Integer>(cost.getCostMinCount());
            });
        }
        this.cacheModifiedCosts.add(cost);
    }

    private void addNewCost(List<AbilityCostList> dataCostLists, CardIndex sourceCardIndex, Ability sourceAbility) {
        for (AbilityCostList costList : dataCostLists) {
            EnerCost enerCost;
            AbilityCost cost = this.handlerSample.getCost(sourceCardIndex);
            if (cost == null) continue;
            cost.setSourceAbility(sourceAbility);
            cost.setSourceCardIndex(sourceCardIndex);
            cost.setSourceCostList(costList);
            cost.setIsAddedCost();
            costList.getDataArray().add(cost);
            this.cacheNewlyAddedCosts.add(cost);
            if (!(cost instanceof EnerCost) || !this.shouldModifyCardDescription(enerCost = (EnerCost)cost)) continue;
            cost.getSourceAbility().addEnerCostDescriptionModifier();
        }
    }

    private void addAlternativeCost(List<AbilityCostList> dataCostLists, CardIndex sourceCardIndex, Ability sourceAbility) {
        AbilityCostList costList = new AbilityCostList(new AbilityCost[0]);
        AbilityCost cost = this.handlerSample.getCost(sourceCardIndex);
        if (cost == null) {
            return;
        }
        if (!(cost instanceof AbilityORCost)) {
            costList.getDataArray().add(cost);
        } else {
            AbilityORCost costOR = (AbilityORCost)cost;
            costList.getDataArray().addAll(List.of(costOR.getCostsList()));
        }
        costList.setSourceAbility(sourceAbility);
        costList.setSourceCardIndex(sourceCardIndex);
        dataCostLists.add(costList);
        this.cacheNewlyAddedCostLists.add(costList);
    }

    public void restore(List<AbilityCostList> dataCostLists) {
        dataCostLists.removeAll(this.cacheNewlyAddedCostLists);
        for (AbilityCostList costList : dataCostLists) {
            for (int i = costList.getDataArray().size() - 1; i >= 0; --i) {
                AbilityCost cost = costList.getDataArray().get(i);
                if (!cost.getClass().equals(this.getCostSample(cost.getSourceCardIndex()).getClass())) continue;
                this.restoreCost(cost, costList, i);
            }
        }
    }

    private void restoreCost(AbilityCost cost, AbilityCostList costList, int arrayId) {
        EnerCost enerCost;
        if (!this.cacheNewlyAddedCosts.contains(cost)) {
            if (!this.cacheModifiedCosts.contains(cost)) {
                return;
            }
            if (cost instanceof EnerCost) {
                enerCost = (EnerCost)cost;
                ModifiableVariable.ModifiableValueReference<String> valueReference = this.mapStringValueReferences.get(enerCost);
                if (valueReference != null) {
                    if (enerCost.getCostString().containsBaseValue(valueReference)) {
                        enerCost.getCostString().removeBaseValue(valueReference);
                    } else if (enerCost.getCostString().containsAddedValue(valueReference)) {
                        enerCost.getCostString().removeValue(valueReference);
                    }
                } else {
                    costList.getDataArray().remove(arrayId);
                }
            } else {
                ModifiableVariable.ModifiableValueReference<Integer> valueReference = this.mapIntegerValueReferences.get(cost);
                if (valueReference != null) {
                    if (cost.getModifiableCostMinCount().containsBaseValue(valueReference)) {
                        cost.getModifiableCostMinCount().removeBaseValue(valueReference);
                    } else if (cost.getModifiableCostMinCount().containsAddedValue(valueReference)) {
                        cost.getModifiableCostMinCount().removeValue(valueReference);
                    }
                } else {
                    costList.getDataArray().remove(arrayId);
                }
            }
            this.cacheModifiedCosts.remove(cost);
        } else {
            costList.getDataArray().remove(arrayId);
            this.cacheNewlyAddedCosts.remove(cost);
        }
        if (cost instanceof EnerCost && this.shouldModifyCardDescription(enerCost = (EnerCost)cost)) {
            cost.getSourceAbility().removeEnerCostDescriptionModifier();
        }
    }

    private boolean shouldModifyCardDescription(EnerCost enerCost) {
        return enerCost.getSourceAbility() != null && !(enerCost.getSourceAbility() instanceof CheckZoneAbility) && enerCost.getSourceAbility().getSourceAttachPlayerRole() == null;
    }

    @Override
    public void dispose() {
        this.handlerSample = null;
        if (this.costSample != null) {
            this.costSample.dispose();
            this.costSample = null;
        }
        this.cacheOldCostListsNum.clear();
        this.mapStringValueReferences.clear();
        this.mapIntegerValueReferences.clear();
        this.cacheNewlyAddedCosts.forEach(AbilityCost::dispose);
        this.cacheNewlyAddedCosts.clear();
        this.cacheModifiedCosts.forEach(AbilityCost::dispose);
        this.cacheModifiedCosts.clear();
        this.cacheNewlyAddedCostLists.forEach(AbilityCostList::dispose);
        this.cacheNewlyAddedCostLists.clear();
        super.dispose();
    }

    @FunctionalInterface
    public static interface SampleCostHandlerNoSource
    extends SampleCostHandler {
        @Override
        default public AbilityCost getCost(CardIndex cardIndex) {
            return this.handle();
        }

        public AbilityCost handle();
    }

    public static enum ModifierMode {
        INCREASE,
        REDUCE,
        SET,
        ALTERNATIVE;

    }

    private static interface SampleCostHandler {
        default public AbilityCost getCost(CardIndex cardIndex) {
            return null;
        }
    }

    @FunctionalInterface
    public static interface SampleCostHandlerWithSource
    extends SampleCostHandler {
        @Override
        default public AbilityCost getCost(CardIndex cardIndex) {
            return this.handle(cardIndex);
        }

        public AbilityCost handle(CardIndex var1);
    }
}

