/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability.modifiers;

import java.util.Objects;
import java.util.function.Supplier;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.data.ModifiableVariable;
import open.batoru.data.ability.modifiers.ConstantModifier;
import open.batoru.data.ability.modifiers.DynamicValueHandler;
import open.batoru.data.ability.modifiers.SampleModifiableVariableHandler;

public class ModifiableValueModifier<T, V, M extends ModifiableVariable<T, V, M>>
extends ConstantModifier {
    private SampleModifiableVariableHandler<T, V, M> handlerSample;
    private T addValue;
    private DynamicValueHandler<T> handlerDynamicValue;
    private ModifiableVariable.ModifiableValueReference<T> valueReference;

    public ModifiableValueModifier(SampleModifiableVariableHandler<T, V, M> handlerSample, Supplier<T> constantValueSupplier) {
        this.handlerSample = handlerSample;
        this.addValue = constantValueSupplier.get();
    }

    public ModifiableValueModifier(SampleModifiableVariableHandler<T, V, M> handlerSample, DynamicValueHandler<T> handlerDynamicValue) {
        this.handlerSample = handlerSample;
        this.handlerDynamicValue = handlerDynamicValue;
    }

    @Override
    public boolean shouldForceUpdate(CardIndex cardIndex) {
        ModifiableVariable<T, V, M> mod = this.handlerSample.getModifiableVariable(cardIndex);
        if (mod == null) {
            return false;
        }
        if (this.handlerDynamicValue != null) {
            T oldAddValue = this.addValue;
            TargetFilter.setDefaultSources(this.getSourceAbility().getSourceCardIndex(), this.getSourceAbility());
            this.addValue = this.handlerDynamicValue.getValue(oldAddValue);
            if (!Objects.equals(oldAddValue, this.addValue)) {
                return true;
            }
        }
        return !mod.containsAddedValue(this.valueReference);
    }

    @Override
    void internalEnable(CardIndex cardIndex) {
        ModifiableVariable<T, V, M> mod = this.handlerSample.getModifiableVariable(cardIndex);
        if (mod != null) {
            this.valueReference = mod.addValue(this.addValue);
        }
    }

    @Override
    void internalDisable(CardIndex cardIndex) {
        ModifiableVariable<T, V, M> mod = this.handlerSample.getModifiableVariable(cardIndex);
        if (mod != null) {
            mod.removeValue(this.valueReference);
        }
    }

    @Override
    public void dispose() {
        this.handlerSample = null;
        this.handlerDynamicValue = null;
        this.valueReference = null;
        super.dispose();
    }
}

