/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability.modifiers;

import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.rulechecks.PlayerRuleCheckData;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.player.PlayerRuleCheckRegistry;
import open.batoru.data.ability.modifiers.ConstantModifier;

public class PlayerRuleCheckModifier<T, V extends PlayerRuleCheckData>
extends ConstantModifier {
    private final PlayerRuleCheckRegistry.PlayerRuleCheckType ruleCheckType;
    private final int hintFlagsOwner;
    private RuleCheck.RuleCheckHandler<T, V> modHandler;

    public PlayerRuleCheckModifier(PlayerRuleCheckRegistry.PlayerRuleCheckType ruleCheckType, int hintFlagsOwner, RuleCheck.RuleCheckHandler<T, V> modHandler) {
        this.ruleCheckType = ruleCheckType;
        this.hintFlagsOwner = hintFlagsOwner;
        this.modHandler = modHandler;
        this.increasePriority();
    }

    @Override
    void internalEnable(CardIndex cardIndex) {
        if ((this.hintFlagsOwner & 1) != 0) {
            this.getRuleCheckByRole(cardIndex.getCurrentOwnerSafe()).addRuleCheck(this.modHandler, this.getSourceAbility());
        }
        if ((this.hintFlagsOwner & 2) != 0) {
            this.getRuleCheckByRole(Game.GamePlayerRole.getOpponentRole(cardIndex.getCurrentOwnerSafe())).addRuleCheck(this.modHandler, this.getSourceAbility());
        }
    }

    @Override
    void internalDisable(CardIndex cardIndex) {
        if ((this.hintFlagsOwner & 1) != 0) {
            this.getRuleCheckByRole(cardIndex.getCurrentOwnerSafe()).removeRuleCheck(this.modHandler);
        }
        if ((this.hintFlagsOwner & 2) != 0) {
            this.getRuleCheckByRole(Game.GamePlayerRole.getOpponentRole(cardIndex.getCurrentOwnerSafe())).removeRuleCheck(this.modHandler);
        }
    }

    private RuleCheck<T, V> getRuleCheckByRole(Game.GamePlayerRole rolePlayer) {
        return (RuleCheck)Game.getCurrentGame().getGameRules().getPlayerRuleChecks(rolePlayer).getRuleCheck(this.ruleCheckType);
    }

    @Override
    public void dispose() {
        this.modHandler = null;
        super.dispose();
    }
}

