/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability.modifiers;

import java.util.HashMap;
import java.util.Map;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.data.ModifiableVariable;
import open.batoru.data.ability.events.EventPowerChanged;
import open.batoru.data.ability.modifiers.ConstantModifier;
import open.batoru.game.overlay.log.events.LogEvent;
import open.batoru.game.overlay.log.events.LogEventPowerChanged;
import open.batoru.ui.FX;
import open.batoru.ui.UI;

public class PowerModifier
extends ConstantModifier {
    private final Map<CardIndex, ModifiableVariable.ModifiableValueReference<Double>> mapValueReferences = new HashMap<CardIndex, ModifiableVariable.ModifiableValueReference<Double>>();
    private double value;
    private DynamicValueHandler handler;
    private LogEvent logEventPowerChanged;

    public PowerModifier(double value) {
        this.value = value;
    }

    public PowerModifier(DynamicValueHandler handler) {
        this.handler = handler;
    }

    @Override
    public boolean shouldForceUpdate(CardIndex cardIndex) {
        double oldValue = this.mapValueReferences.containsKey(cardIndex) ? this.mapValueReferences.get(cardIndex).value().doubleValue() : cardIndex.getIndexedInstance().getPower().getValue().doubleValue();
        double addValue = this.calculateNewPowerValue(cardIndex);
        double newValue = cardIndex.getIndexedInstance().getPower().testAddedValue(addValue);
        return newValue == oldValue == (cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_POWER_BE_CHANGED).check(cardIndex, this.getSourceAbility(), addValue) == RuleCheck.RuleCheckState.BLOCK);
    }

    private double calculateNewPowerValue(CardIndex cardIndex) {
        if (this.handler == null) {
            return this.value;
        }
        TargetFilter.setDefaultSources(this.getSourceAbility().getSourceCardIndex(), this.getSourceAbility());
        return this.handler.getValue(cardIndex);
    }

    @Override
    void internalEnable(CardIndex cardIndex) {
        double oldValue = cardIndex.getIndexedInstance().getPower().getValue();
        cardIndex.getIndexedInstance().getPower().setSourceAbility(this.getSourceAbility());
        this.mapValueReferences.compute(cardIndex, (cardIndexPower, valueReference) -> {
            cardIndex.getIndexedInstance().getPower().removeValue(valueReference);
            return cardIndex.getIndexedInstance().getPower().addValue(this.calculateNewPowerValue(cardIndex));
        });
        double newValue = cardIndex.getIndexedInstance().getPower().getValue();
        double addValue = newValue - oldValue;
        EventPowerChanged event = new EventPowerChanged(cardIndex, this.getSourceAbility(), newValue, addValue);
        this.logEventPowerChanged = new LogEventPowerChanged(event, oldValue);
        if (addValue > 0.0) {
            FX.run(() -> UI.getTabGame().getFieldSceneOverlay().getGameLog().addEntry(this.logEventPowerChanged));
        }
        if (cardIndex.getIndexedInstance().getRCRegistry().getRuleCheck(CardRuleCheckRegistry.CardRuleCheckType.CAN_POWER_BE_CHANGED).check(cardIndex, this.getSourceAbility(), addValue) == RuleCheck.RuleCheckState.BLOCK) {
            this.clearValue(cardIndex);
            FX.run(() -> this.logEventPowerChanged.disable());
            return;
        }
        if (oldValue > 0.0) {
            Game.getCurrentGame().getGameRules().getEffectProcessor().callConstantModifierEvent(this.getSourceAbility(), event);
        }
    }

    @Override
    void internalDisable(CardIndex cardIndex) {
        double oldValue = cardIndex.getIndexedInstance().getPower().getValue();
        this.clearValue(cardIndex);
        double newValue = cardIndex.getIndexedInstance().getPower().getValue();
        if (cardIndex.getIndexedInstance() != null && oldValue != newValue) {
            this.logEventPowerChanged = new LogEventPowerChanged(new EventPowerChanged(cardIndex, this.getSourceAbility(), newValue, newValue - oldValue), oldValue);
            FX.run(() -> UI.getTabGame().getFieldSceneOverlay().getGameLog().addEntry(this.logEventPowerChanged));
        }
    }

    private void clearValue(CardIndex cardIndex) {
        this.mapValueReferences.computeIfPresent(cardIndex, (cardIndexPower, mapValueReferences) -> {
            cardIndex.getIndexedInstance().getPower().removeValue(mapValueReferences);
            return null;
        });
    }

    @Override
    public void dispose() {
        this.mapValueReferences.clear();
        this.handler = null;
        this.logEventPowerChanged = null;
        super.dispose();
    }

    @FunctionalInterface
    public static interface DynamicValueHandler {
        public double getValue(CardIndex var1);
    }
}

