/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability.modifiers;

import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.data.ModifiableFlag;
import open.batoru.data.ModifiableVariable;
import open.batoru.data.ability.events.EventFreeze;
import open.batoru.data.ability.modifiers.ConstantModifier;

public class StateFlagModifier
extends ConstantModifier {
    private final int flagsState;
    private ModifiableVariable.ModifiableValueReference<Integer> valueReference;

    public StateFlagModifier(int flagsState) {
        this.flagsState = flagsState;
    }

    @Override
    public boolean shouldForceUpdate(CardIndex cardIndex) {
        return this.getLastState(cardIndex) && !cardIndex.getIndexedInstance().getCardStateFlags().containsAddedValue(this.valueReference);
    }

    @Override
    void internalEnable(CardIndex cardIndex) {
        ModifiableFlag flagsCardState = cardIndex.getIndexedInstance().getCardStateFlags();
        if ((flagsCardState.getValue() & 0x10000) == 0 && (this.flagsState & 0x10000) != 0) {
            Game.getCurrentGame().getGameRules().getEffectProcessor().callConstantModifierEvent(this.getSourceAbility(), new EventFreeze(cardIndex, this.getSourceAbility()));
        }
        this.valueReference = flagsCardState.addValue(this.flagsState);
    }

    @Override
    void internalDisable(CardIndex cardIndex) {
        cardIndex.getIndexedInstance().getCardStateFlags().removeValue(this.valueReference);
    }

    @Override
    public void dispose() {
        this.valueReference = null;
        super.dispose();
    }
}

