/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability.stock;

import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.data.DataTable;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.AbilityConst;
import open.batoru.data.ability.AbilityEffectNoSource;
import open.batoru.data.ability.stock.StockAbility;

public final class StockAbilityHarmony
extends StockAbility {
    private final int numPicks;
    private TargetFilter filter;

    public StockAbilityHarmony(int numPicks, TargetFilter filter) {
        this.numPicks = numPicks;
        this.filter = filter.own().anyLRIG().upped();
        HarmonyAbility ability = new HarmonyAbility(this::onHarmonyEff);
        this.setAbility(ability);
        ability.setOnAbilityInit(() -> {
            String sourceDescription = ability.getSourceCardIndex().getCardReference().getDescription();
            int tokenHarmony = sourceDescription.indexOf("=H");
            if (tokenHarmony != -1) {
                String descriptionCut = sourceDescription.substring(tokenHarmony);
                this.setAbilityDescription(descriptionCut.substring(0, descriptionCut.indexOf("\n")));
            } else {
                this.setAbilityDescription("=H");
            }
        });
    }

    private void onHarmonyEff() {
        CardIndex cardIndex = this.getAbility().getSourceCardIndex();
        if (!cardIndex.getIndexedInstance().isState(16384)) {
            DataTable<CardIndex> data = cardIndex.getIndexedInstance().playerTargetCard(0, this.numPicks, AbilityConst.ChoiceLogic.BOOLEAN, this.filter);
            if (data.get() != null) {
                cardIndex.getIndexedInstance().down(data);
            } else {
                cardIndex.getIndexedInstance().down(cardIndex);
            }
        }
    }

    @Override
    public void dispose() {
        this.filter = null;
        super.dispose();
    }

    private static class HarmonyAbility
    extends Ability {
        public HarmonyAbility(AbilityEffectNoSource effect) {
            this.setEffect(effect);
            this.setActiveEvent(GameConst.GameEventId.ENTER);
        }
    }
}

