/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability.stock;

import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.data.CardConst;
import open.batoru.data.Cost;
import open.batoru.data.ability.AbilityCondition;
import open.batoru.data.ability.AbilityConst;
import open.batoru.data.ability.ActionAbility;
import open.batoru.data.ability.cost.EnerCost;
import open.batoru.data.ability.stock.StockAbility;
import open.batoru.parsers.LanguageParser;

public final class StockAbilityRide
extends StockAbility {
    public StockAbilityRide() {
        ActionAbility ability = new ActionAbility(new EnerCost(Cost.color(CardConst.CardColor.RED, 0)), this::onActionEff);
        ability.setCondition(this::onActionEffCond);
        ability.setUseLimit(AbilityConst.UseLimit.TURN, 1);
        this.setAbility(ability);
        this.setAbilityDescription(LanguageParser.getString("CARD_TEXT_STOCK_ABILITY_RIDE"));
    }

    private AbilityCondition.ConditionState onActionEffCond() {
        if (this.getAbility().getSourceCardIndex().getIndexedInstance().isState(0x200000)) {
            return AbilityCondition.ConditionState.BAD;
        }
        return new TargetFilter().own().SIGNI().withClass(CardConst.CardSIGNIClass.RIDING_MACHINE).not(new TargetFilter().drive()).getValidTargetsCount() > 0 ? AbilityCondition.ConditionState.OK : AbilityCondition.ConditionState.WARN;
    }

    private void onActionEff() {
        CardIndex cardIndexLRIG = this.getAbility().getSourceCardIndex();
        CardIndex target = cardIndexLRIG.getIndexedInstance().playerTargetCard(new TargetFilter(TargetFilter.TargetHint.RIDE).own().SIGNI().withClass(CardConst.CardSIGNIClass.RIDING_MACHINE)).get();
        cardIndexLRIG.getIndexedInstance().ride(target);
    }
}

