/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.data.ability.stock;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import open.batoru.catalog.description.DescriptionParser;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.core.gameplay.rulechecks.CardRuleCheckData;
import open.batoru.core.gameplay.rulechecks.RuleCheck;
import open.batoru.core.gameplay.rulechecks.card.CardRuleCheckRegistry;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.AbilityCondition;
import open.batoru.data.ability.AbilityConditionWithSource;
import open.batoru.data.ability.ConstantAbility;
import open.batoru.data.ability.modifiers.RuleCheckModifier;
import open.batoru.data.ability.stock.StockAbility;
import open.batoru.game._3d.textures.UtilTextureLayer;
import open.batoru.parsers.LanguageParser;

public final class StockAbilityShadow
extends StockAbility {
    private AbilityConditionWithSource addCondition;
    private static Pattern PATTERN_SHADOW_TEXT;

    public StockAbilityShadow() {
        this(null);
    }

    public StockAbilityShadow(AbilityConditionWithSource addCondition) {
        this(addCondition, 0);
    }

    public StockAbilityShadow(AbilityConditionWithSource addCondition, int offsetAbilityId) {
        this(addCondition, null, offsetAbilityId);
    }

    public StockAbilityShadow(AbilityConditionWithSource addCondition, Ability.DynamicAbilityDescriptionHandler handlerDynamicDescription) {
        this(addCondition, handlerDynamicDescription, 0);
    }

    public StockAbilityShadow(AbilityConditionWithSource addCondition, Ability.DynamicAbilityDescriptionHandler handlerDynamicDescription, int offsetAbilityId) {
        this.addCondition = addCondition;
        ConstantAbility ability = new ConstantAbility(new RuleCheckModifier<RuleCheck.RuleCheckState, CardRuleCheckData>(CardRuleCheckRegistry.CardRuleCheckType.CAN_BE_TARGETED, this::onConstEffModRuleCheck));
        ability.setDynamicAbilityDescription(handlerDynamicDescription);
        this.setAbility(ability);
        String textShadow = LanguageParser.getString("CARD_TEXT_STOCK_ABILITY_SHADOW");
        if (addCondition == null) {
            this.setAbilityDescription(textShadow);
        } else {
            ability.setOnAbilityInit(() -> {
                String sourceDescription = DescriptionParser.getAbilityDescription(ability.getSourceAttachAbility() != null ? ability.getSourceAttachAbility() : ability);
                int tokenStart = textShadow.indexOf(91);
                String textConstHeader = textShadow.substring(0, tokenStart);
                String textShadowStart = textShadow.substring(tokenStart, textShadow.length() - 2);
                if (PATTERN_SHADOW_TEXT == null) {
                    PATTERN_SHADOW_TEXT = Pattern.compile(Pattern.quote(textShadowStart) + "(.*?)]]");
                }
                Matcher matcher = PATTERN_SHADOW_TEXT.matcher(sourceDescription);
                for (int i = 0; i <= offsetAbilityId && matcher.find(); ++i) {
                }
                this.setAbilityDescription((String)(matcher.hitEnd() ? textShadow : textConstHeader + matcher.group()));
            });
        }
        ability.setOnAbilityEnabled(cardIndex -> cardIndex.getSourceCard3D().getCardMeshFace().addTextureLayer(UtilTextureLayer.getTexture(UtilTextureLayer.TextureType.SHADOW)));
        ability.setOnAbilityDisabled(cardIndex -> cardIndex.getSourceCard3D().getCardMeshFace().removeTextureLayer(UtilTextureLayer.TextureType.SHADOW.getAlias()));
    }

    private RuleCheck.RuleCheckState onConstEffModRuleCheck(CardRuleCheckData data) {
        TargetFilter.setDefaultSources(this.getAbility().getSourceCardIndex(), this.getAbility());
        return data.getSourceAbility() != null && data.getGenericData(0) != this.getAbility().getSourceCardIndex().getIndexedInstance().getCurrentOwner() && (this.addCondition == null || data.getSourceCardIndex() != null && data.getSourceAbility().getSourceAttachPlayerRole() == null && this.addCondition.getState(data.getSourceCardIndex()) == AbilityCondition.ConditionState.OK) ? RuleCheck.RuleCheckState.BLOCK : RuleCheck.RuleCheckState.IGNORE;
    }

    @Override
    public void dispose() {
        this.addCondition = null;
        super.dispose();
    }
}

