/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game;

import javafx.animation.Animation;
import javafx.animation.ScaleTransition;
import javafx.animation.SequentialTransition;
import javafx.scene.Node;
import javafx.util.Duration;
import open.batoru.ImageCache;
import open.batoru.Settings;
import open.batoru.data.CardConst;
import open.batoru.game._3d.Group3D;
import open.batoru.game._3d.Plane;
import open.batoru.game._3d.TexturedMesh;

public class FieldBackground
extends Group3D {
    private final Plane plane = new Plane(1600, ImageCache.INSTANCE.getImage("textures/zones/field_background.png"));

    public FieldBackground(double x, double y) {
        this.plane.setTranslate(x, y);
        this.getChildren().add((Object)this.plane);
        this.setTransZ(10.0);
        this.plane.getRender().setScaleX(0.0);
        this.plane.getRender().setScaleY(0.0);
        this.plane.getRender().setScaleZ(0.0);
    }

    public TexturedMesh getMesh() {
        return this.plane;
    }

    public void playAnimation(int duration, CardConst.CardColor oldColor, CardConst.CardColor newColor) {
        if (oldColor == newColor) {
            return;
        }
        if (oldColor == null) {
            this.plane.getMaterial().setDiffuseColor(CardConst.CardColor.utilCardColorToJavaFXColor(newColor, 1.0, 0.5));
            ScaleTransition aniScale = this.newAnimation(duration, 0.0, 1.0);
            aniScale.play();
        } else {
            SequentialTransition seqAni = new SequentialTransition(new Animation[]{this.newAnimation((double)duration * 0.5, 1.0, 0.0), this.newAnimation((double)duration * 0.5, 0.0, 1.0)});
            ((Animation)seqAni.getChildren().getFirst()).setOnFinished(e -> this.plane.getMaterial().setDiffuseColor(CardConst.CardColor.utilCardColorToJavaFXColor(newColor, 1.0, 0.5)));
            seqAni.play();
        }
    }

    private ScaleTransition newAnimation(double duration, double scaleFrom, double scaleTo) {
        ScaleTransition aniScale = new ScaleTransition(Duration.millis((double)(duration * 2.0 * Settings.INSTANCE.getAnimationSpeed())), (Node)this.plane.getRender());
        aniScale.setFromX(scaleFrom);
        aniScale.setFromY(scaleFrom);
        aniScale.setFromZ(scaleFrom);
        aniScale.setToX(scaleTo);
        aniScale.setToY(scaleTo);
        aniScale.setToZ(scaleTo);
        return aniScale;
    }
}

