/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game;

import java.util.ArrayList;
import open.batoru.core.Deck;
import open.batoru.core.Game;
import open.batoru.core.gameplay.GameConst;
import open.batoru.game.PlayerField;
import open.batoru.game.Zone;
import open.batoru.ui.UI;

public class FieldData {
    private int coins;
    private int subscribers;
    private int collaboLivers;
    private ArrayList<String> studentBonds;

    public int setCoins(int value) {
        this.coins = Math.max(0, Math.min(5, value));
        return this.coins;
    }

    public int getCoins() {
        return this.coins;
    }

    public void setSubscribers(int value) {
        this.subscribers = value;
    }

    public int getSubscribers() {
        return this.subscribers;
    }

    public void setCollaboLivers(int value) {
        this.collaboLivers = value;
    }

    public int getCollaboLivers() {
        return this.collaboLivers;
    }

    public void gainStudentBond(String imageSet) {
        if (this.studentBonds == null) {
            this.studentBonds = new ArrayList();
        }
        this.studentBonds.add(imageSet);
    }

    public boolean hasStudentBond(String imageSet) {
        return this.studentBonds != null && this.studentBonds.contains(imageSet);
    }

    public int getTotalStudentBonds() {
        return this.studentBonds != null ? this.studentBonds.size() : 0;
    }

    public static Zone getZoneByLocation(Game.GamePlayerRole playerRole, GameConst.CardLocation location) {
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(playerRole);
        return switch (location) {
            case GameConst.CardLocation.DECK_MAIN -> field.getDeckZone(Deck.DeckType.MAIN);
            case GameConst.CardLocation.DECK_LRIG -> field.getDeckZone(Deck.DeckType.LRIG);
            case GameConst.CardLocation.TRASH -> field.getTrashZone(Deck.DeckType.MAIN);
            case GameConst.CardLocation.TRASH_LRIG -> field.getTrashZone(Deck.DeckType.LRIG);
            case GameConst.CardLocation.HAND -> field.getHand();
            case GameConst.CardLocation.ENER -> field.getEnerZone();
            case GameConst.CardLocation.CHECK_ZONE -> field.getCheckZone();
            case GameConst.CardLocation.LIFE_CLOTH -> field.getLifeClothZone();
            case GameConst.CardLocation.LRIG -> field.getLRIGZone();
            case GameConst.CardLocation.LRIG_ASSIST_LEFT -> field.getLRIGAssistZoneLeft();
            case GameConst.CardLocation.LRIG_ASSIST_RIGHT -> field.getLRIGAssistZoneRight();
            case GameConst.CardLocation.KEY -> field.getKeyZone();
            case GameConst.CardLocation.SIGNI_LEFT -> field.getSIGNIZone(GameConst.SIGNIZonePosition.LEFT);
            case GameConst.CardLocation.SIGNI_CENTER -> field.getSIGNIZone(GameConst.SIGNIZonePosition.CENTER);
            case GameConst.CardLocation.SIGNI_RIGHT -> field.getSIGNIZone(GameConst.SIGNIZonePosition.RIGHT);
            case GameConst.CardLocation.REVEALED -> field.getRevealZone();
            case GameConst.CardLocation.LOOKED -> field.getLookZone();
            case GameConst.CardLocation.CHEER -> field.getCheerZone();
            default -> null;
        };
    }
}

