/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game;

import javafx.scene.Node;
import open.batoru.core.gameplay.GameConst;
import open.batoru.game.FieldZone;
import open.batoru.game.FieldZoneAttachedAbilitiesIndicator;
import open.batoru.game.FieldZoneUnderCardsIndicators;
import open.batoru.game.PlayerField;
import open.batoru.game._3d.Card3D;

public abstract class FieldStackZone
extends FieldZone {
    private final FieldZoneUnderCardsIndicators zoneUnderCards = new FieldZoneUnderCardsIndicators();
    private FieldZoneAttachedAbilitiesIndicator zoneAttachedAbilities;

    public FieldStackZone(double x, double y, FieldZone.ZoneType zoneType) {
        super(x, y, 349, 450, zoneType);
        this.zoneUnderCards.setTransZ(2.0);
        this.getNode().getChildren().addAll((Object[])new Node[]{this.zoneUnderCards});
    }

    @Override
    public void removeCardFromZoneList(Card3D card3D) {
        this.zoneUnderCards.removeUnderType(card3D.getCardIndex().getUnderType());
        super.removeCardFromZoneList(card3D);
    }

    public final FieldZoneAttachedAbilitiesIndicator getZoneAttachedAbilitiesIndicator() {
        return this.zoneAttachedAbilities;
    }

    public final FieldZoneUnderCardsIndicators getZoneUnderCardsIndicators() {
        return this.zoneUnderCards;
    }

    public void installZoneAttachedAbilitiesIndicator(PlayerField field) {
        if (this.zoneAttachedAbilities != null) {
            return;
        }
        this.zoneAttachedAbilities = new FieldZoneAttachedAbilitiesIndicator();
        this.zoneAttachedAbilities.setTranslate(this.getNode().getTransX() + -0.5, this.getNode().getTransY() - 197.0, this.getNode().getTransZ() - 1.0);
        if (this.isFlipped()) {
            this.zoneAttachedAbilities.setRotateZ(-180.0);
        }
        field.getChildren().add((Object)this.zoneAttachedAbilities);
    }

    public boolean hasZoneObject(GameConst.CardUnderType underType) {
        return underType.getUnderCategory() == GameConst.CardUnderCategory.ZONE && this.zoneUnderCards.hasUnderType(underType);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.zoneAttachedAbilities != null) {
            this.zoneAttachedAbilities.dispose();
        }
    }
}

