/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game;

import java.util.Optional;
import javafx.animation.FadeTransition;
import javafx.animation.Transition;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;
import open.batoru.game.FieldZone;
import open.batoru.game.PlayerField;
import open.batoru.game._3d.Group3D;
import open.batoru.game._3d.MagicBoxLid;
import open.batoru.game.animations.tracker.AnimationTracker;

public class FieldZoneHighlighter
extends Group3D {
    private final PlayerField field;
    private final Rectangle rectangle = new Rectangle();
    private final FadeTransition ft = new FadeTransition();

    public FieldZoneHighlighter(PlayerField field) {
        this.field = field;
        this.rectangle.setFill((Paint)Color.WHITE);
        this.rectangle.setMouseTransparent(true);
        this.rectangle.setVisible(false);
        this.ft.setDuration(Duration.millis((double)500.0));
        this.ft.setNode((Node)this.rectangle);
        this.ft.setFromValue(0.0);
        this.ft.setToValue(0.25);
        this.ft.setCycleCount(-1);
        this.ft.setAutoReverse(true);
        this.getChildren().add((Object)this.rectangle);
    }

    public void install(FieldZone zone) {
        if (this.rectangle.isVisible()) {
            this.uninstall();
        }
        this.rectangle.setWidth((double)zone.getWidth());
        this.rectangle.setHeight((double)zone.getHeight());
        this.setTransX(zone.getNode().getTransX() - (double)zone.getWidth() * 0.5);
        this.setTransY(zone.getNode().getTransY() - (double)zone.getHeight() * 0.5);
        this.setTransZ(zone.getNode().getTransZ() - 0.5);
        this.field.getChildren().remove((Object)this);
        Optional<Node> magicBoxLid = this.field.getChildren().stream().filter(MagicBoxLid.class::isInstance).findFirst();
        if (magicBoxLid.isEmpty()) {
            this.field.getChildren().add(this.field.getChildren().indexOf((Object)zone.getNode()) + 1, (Object)this);
        } else {
            this.field.getChildren().add(this.field.getChildren().indexOf((Object)magicBoxLid.get()) + 2, (Object)this);
        }
        this.rectangle.setVisible(true);
        AnimationTracker.addRunningAnimation((Transition)this.ft);
        this.ft.play();
    }

    public void uninstall() {
        this.rectangle.setVisible(false);
        AnimationTracker.removeRunningAnimation((Transition)this.ft);
        this.ft.stop();
    }
}

