/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.paint.Color;
import open.batoru.ImageCache;
import open.batoru.game._3d.Group3D;
import open.batoru.game._3d.Plane;
import open.batoru.game.animations.AnimationPowerChange;

public class FieldZoneNumbers
extends Group3D {
    private final List<Plane> listNumberPlanes = new ArrayList<Plane>();
    private final NumberTexture textureType;
    private Color textureColor;
    private AnimationPowerChange aniChange;
    private double value = -1.0;

    public FieldZoneNumbers(NumberTexture textureType) {
        this.textureType = textureType;
        this.setMouseTransparent(true);
    }

    public void adjustValue(double baseValue, double oldValue, double newValue) {
        if (this.aniChange != null) {
            this.aniChange.stop();
        }
        if (oldValue != Double.POSITIVE_INFINITY && newValue != Double.POSITIVE_INFINITY) {
            this.aniChange = new AnimationPowerChange(this, baseValue, oldValue, newValue);
            this.aniChange.play();
        } else {
            this.setValue(newValue);
        }
    }

    public void setValue(double value) {
        if (this.value == value) {
            return;
        }
        this.getChildren().clear();
        this.listNumberPlanes.clear();
        if (value < 0.0) {
            value = 0.0;
        }
        if (value == Double.POSITIVE_INFINITY) {
            Plane plane = new Plane(90, 64, ImageCache.INSTANCE.getImage(ImageCache.getDigitsTexturePath(Integer.MAX_VALUE)), Plane.TextureTrimMode.FRAME);
            this.listNumberPlanes.add(plane);
            this.getChildren().add((Object)plane);
            return;
        }
        String numberString = String.valueOf(Math.round(value));
        double originOffset = -this.calculateOffset(numberString.length() - 1) / 2.0;
        for (int i = 0; i < numberString.length(); ++i) {
            int digit = Character.digit(numberString.charAt(i), 10);
            Plane plane = new Plane(45, 64, ImageCache.INSTANCE.getImage(ImageCache.getDigitsTexturePath(digit, this.textureType)), this.textureType == NumberTexture.GRADIENT ? Plane.TextureTrimMode.FRAME : Plane.TextureTrimMode.NONE);
            plane.setTransX(originOffset + this.calculateOffset(i));
            this.listNumberPlanes.add(plane);
            this.getChildren().add((Object)plane);
        }
        if (this.textureColor != null) {
            this.setColor(this.textureColor);
        }
        this.value = value;
    }

    public void setColor(Color color) {
        this.textureColor = color;
        for (Plane plane : this.listNumberPlanes) {
            plane.getMaterial().setDiffuseColor(color);
        }
    }

    public double getValue() {
        return this.value;
    }

    public AnimationPowerChange getAnimation() {
        return this.aniChange;
    }

    public final double calculateOffset(int i) {
        return i * 50;
    }

    public void setColorByValue(double valueBase, double valueNew) {
        if (valueNew == valueBase) {
            this.setColor(Color.WHITE);
        } else if (valueNew > valueBase) {
            this.setColor(Color.LIGHTGREEN);
        } else {
            this.setColor(Color.LIGHTCORAL);
        }
    }

    public static enum NumberTexture {
        GRADIENT,
        OUTLINE;

    }
}

