/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game;

import java.util.ArrayList;
import java.util.List;
import open.batoru.game.Zone;
import open.batoru.game._3d.Group3D;
import open.batoru.game.animations.AnimationSpinnerRearrange;
import open.batoru.game.animations.AnimationSpinnerRotate;

public class FieldZoneSpinner
extends Group3D {
    private final List<Group3D> listSpinNodes = new ArrayList<Group3D>();
    private AnimationSpinnerRearrange aniRearrange;
    private AnimationSpinnerRotate aniRotate = new AnimationSpinnerRotate();

    public FieldZoneSpinner(double x, double y) {
        this.setTranslate(x, y, 0.0);
    }

    public FieldZoneSpinner(Zone zone, Group3D ... spinNodes) {
        this.setTranslate(zone.getNode());
        for (Group3D node : spinNodes) {
            this.listSpinNodes.add(node);
            this.getChildren().add((Object)node);
            if (zone.isFlipped()) {
                node.setRotateZ(node.getRotateZ() + 180.0);
            }
            node.setMouseTransparent(true);
        }
    }

    public void addSpinNode(Group3D nodeSpin) {
        this.stopAnimations();
        this.listSpinNodes.add(nodeSpin);
        this.getChildren().add((Object)nodeSpin);
        nodeSpin.setRotateY(this.getRotateY() + (double)(360.0f / (float)this.getChildren().size()));
        nodeSpin.setRotateX(90.0);
    }

    public void removeSpinNode() {
        this.stopAnimations();
        this.listSpinNodes.removeLast();
        this.getChildren().removeLast();
    }

    public void playRearrangeAnimation() {
        this.aniRearrange = new AnimationSpinnerRearrange(this);
        this.aniRearrange.setOnFinished(e -> this.startRotation());
        this.aniRearrange.play();
    }

    public void stopAnimations() {
        if (this.aniRearrange != null) {
            this.aniRearrange.stop();
        }
        this.aniRotate.stop();
        this.aniRearrange = null;
    }

    public void startRotation() {
        this.aniRotate.stop();
        this.aniRotate.setSpinner(this);
        this.aniRotate.play();
    }

    public void setRotateAnimation(AnimationSpinnerRotate aniRotate) {
        if (aniRotate != null) {
            this.aniRotate = aniRotate;
        }
    }

    public List<Group3D> getListSpinNodes() {
        return this.listSpinNodes;
    }
}

