/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game;

import javafx.scene.Node;
import open.batoru.core.Deck;
import open.batoru.core.Game;
import open.batoru.game.FieldConst;
import open.batoru.game.PlayerField;
import open.batoru.game.Zone;
import open.batoru.game.ZoneDeck;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.Group3D;
import open.batoru.ui.UI;
import open.batoru.ui.UtilDispose;

public class GameField
extends Group3D {
    private PlayerField playerFieldTop;
    private PlayerField playerFieldBottom;
    private static Game.GamePlayerRole roleHighlightDefaultPlayer;

    public void initField() {
        this.getChildren().clear();
        this.playerFieldTop = new PlayerField(true);
        this.playerFieldBottom = new PlayerField(false);
        this.playerFieldTop.initZoneHighlighter();
        this.playerFieldTop.initVisualStateCoordinator();
        this.playerFieldBottom.initZoneHighlighter();
        this.playerFieldBottom.initVisualStateCoordinator();
        this.initMainDeckCards(this.playerFieldTop);
        this.initMainDeckCards(this.playerFieldBottom);
        this.getChildren().addAll((Object[])new Node[]{this.playerFieldTop, this.playerFieldBottom});
        this.playerFieldTop.installExtraNodes();
        this.playerFieldBottom.installExtraNodes();
        UtilDispose.TEMP.attachChildDisposeListener((Node)this.playerFieldTop);
        UtilDispose.TEMP.attachChildDisposeListener((Node)this.playerFieldBottom);
    }

    public void clearAll() {
        this.playerFieldTop.dispose();
        this.playerFieldBottom.dispose();
    }

    private void initMainDeckCards(PlayerField field) {
        for (int i = 0; i < 40; ++i) {
            this.initCard(field, Deck.DeckType.MAIN);
        }
    }

    public Card3D initLRIGDeckCard(PlayerField field) {
        return this.initCard(field, Deck.DeckType.LRIG);
    }

    private Card3D initCard(PlayerField field, Deck.DeckType deckType) {
        Card3D card3D = new Card3D(deckType);
        card3D.getCardIndex().setSourceCard3D(card3D);
        ZoneDeck zone = field.getDeckZone(deckType);
        card3D.setTranslate(zone.getNextCardOrigin());
        card3D.setRotate(zone.getNextCardRotation());
        field.getChildren().add((Object)card3D);
        zone.addCardToZoneList(card3D, Zone.ZonePosition.TOP);
        return card3D;
    }

    public static void setHighlightDefaultPlayer(Game.GamePlayerRole rolePlayer) {
        roleHighlightDefaultPlayer = rolePlayer;
        GameField.highlightPlayerField(rolePlayer);
    }

    public static Game.GamePlayerRole getHighlightDefaultPlayer() {
        return roleHighlightDefaultPlayer;
    }

    public static void highlightPlayerField(Game.GamePlayerRole rolePlayer) {
        if (rolePlayer == null) {
            rolePlayer = roleHighlightDefaultPlayer == null ? Game.getCurrentGame().getGameRules().getTurnPlayer() : roleHighlightDefaultPlayer;
        }
        UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(rolePlayer).setZoneColor(rolePlayer == Game.getCurrentGame().getPlayerRole() ? FieldConst.FIELD_COLOR_OWN : FieldConst.FIELD_COLOR_OPPONENT);
        UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(Game.GamePlayerRole.getOpponentRole(rolePlayer)).setZoneColor(FieldConst.FIELD_COLOR_DIMMED);
    }

    public PlayerField getTopPlayerField() {
        return this.playerFieldTop;
    }

    public PlayerField getBottomPlayerField() {
        return this.playerFieldBottom;
    }

    public PlayerField getPlayerFieldByZoneFlip(boolean isFlipped) {
        return isFlipped ? this.getTopPlayerField() : this.getBottomPlayerField();
    }

    public PlayerField getPlayerFieldByRole(Game.GamePlayerRole role) {
        if (role == null) {
            throw new IllegalArgumentException();
        }
        return role == Game.getCurrentGame().getPlayerRole() ? this.playerFieldBottom : this.playerFieldTop;
    }
}

