/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game;

import open.batoru.core.Deck;
import open.batoru.core.gameplay.GameConst;
import open.batoru.game.FieldZone;
import open.batoru.game.FieldZoneNumbers;
import open.batoru.game.Zone;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.Vector3D;

public class ZoneDeck
extends FieldZone {
    private static final Vector3D CARD_ROTATION_FACEDOWN = new Vector3D(0.0, 180.0, 0.0);
    private final Deck.DeckType deckType;
    private final boolean isPublicZone;
    private final FieldZoneNumbers zoneNumbers = new FieldZoneNumbers(FieldZoneNumbers.NumberTexture.OUTLINE);

    public ZoneDeck(Deck.DeckType deckType, boolean isPublicZone, double x, double y) {
        super(x, y, 349, 450, isPublicZone ? (deckType == Deck.DeckType.MAIN ? FieldZone.ZoneType.TRASH : FieldZone.ZoneType.TRASH_LRIG) : (deckType == Deck.DeckType.MAIN ? FieldZone.ZoneType.DECK_MAIN : FieldZone.ZoneType.DECK_LRIG));
        this.deckType = deckType;
        this.isPublicZone = isPublicZone;
        if (ZoneDeck.getShouldFlip()) {
            this.zoneNumbers.setRotateZ(180.0);
        }
        this.zoneNumbers.setScale(1.2);
        this.zoneNumbers.setTransZ(-2.0);
        this.zoneNumbers.setValue(0.0);
    }

    @Override
    protected Vector3D getCardRotation(int i) {
        return this.isPublicZone ? Vector3D.ZERO : CARD_ROTATION_FACEDOWN;
    }

    @Override
    public void addCardToZoneList(Card3D card3D, Zone.ZonePosition addPosition) {
        super.addCardToZoneList(card3D, addPosition);
        card3D.setShouldClearImageSet(card3D.shouldClearImageSet() && !this.isPublicZone && (addPosition == Zone.ZonePosition.BOTTOM || this.deckType == Deck.DeckType.LRIG));
        if (addPosition == Zone.ZonePosition.TOP || this.getTotalCards() == 1) {
            card3D.getVisibleMesh().getChildren().add((Object)this.zoneNumbers);
        }
    }

    @Override
    public void removeCardFromZoneList(Card3D card3D) {
        super.removeCardFromZoneList(card3D);
        if (this.getLastModifiedIndex() == this.getTotalCards()) {
            if (this.getTotalCards() > 0) {
                this.getTopCard().getVisibleMesh().getChildren().add((Object)this.zoneNumbers);
            } else {
                card3D.getVisibleMesh().getChildren().remove((Object)this.zoneNumbers);
            }
        }
    }

    @Override
    public void updateZone(Zone.OnRearrangeAnimationInterpolateHandler.RearrangeType rearrangeType) {
        this.zoneNumbers.setValue(this.getTotalCards());
    }

    @Override
    public GameConst.CardLocation getZoneLocation() {
        return this.isPublicZone ? (this.deckType == Deck.DeckType.MAIN ? GameConst.CardLocation.TRASH : GameConst.CardLocation.TRASH_LRIG) : (this.deckType == Deck.DeckType.MAIN ? GameConst.CardLocation.DECK_MAIN : GameConst.CardLocation.DECK_LRIG);
    }
}

