/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game;

import javafx.beans.property.StringProperty;
import open.batoru.core.Game;
import open.batoru.core.gameplay.GameConst;
import open.batoru.game.FieldZone;
import open.batoru.game.Zone;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.Vector3D;

public class ZoneKey
extends FieldZone {
    private static final Vector3D CARD_ROTATION = new Vector3D(0.0, 0.0, 90.0);

    public ZoneKey(double x, double y, boolean isLRIGZone) {
        super(x, y, isLRIGZone ? 395 : 349, isLRIGZone ? 450 : 250, isLRIGZone ? FieldZone.ZoneType.LRIG_KEY : FieldZone.ZoneType.KEY);
        this.getNode().setVisible(false);
    }

    @Override
    public void addCardToZoneList(Card3D card3D, Zone.ZonePosition addPosition) {
        super.addCardToZoneList(card3D, addPosition);
        if (Game.getCurrentGame().getGameServerPortOffset() != 0) {
            StringProperty imageProperty = Game.getCurrentGame().getRoom().getPlayerData(Zone.getZoneOwner(this)).getKeysImagesProperty();
            if (this.getTotalCards() == 1) {
                imageProperty.set((Object)card3D.getCardIndex().getImageSet());
            } else {
                imageProperty.set((Object)((String)imageProperty.get() + "~" + card3D.getCardIndex().getImageSet()));
            }
        }
    }

    @Override
    public void removeCardFromZoneList(Card3D card3D) {
        super.removeCardFromZoneList(card3D);
        if (Game.getCurrentGame().getGameServerPortOffset() != 0) {
            StringProperty imageProperty = Game.getCurrentGame().getRoom().getPlayerData(Zone.getZoneOwner(this)).getKeysImagesProperty();
            if (this.getTotalCards() == 0) {
                imageProperty.set((Object)"");
            } else {
                String imageSet;
                String value = (String)imageProperty.get();
                if (value.startsWith(imageSet = card3D.getCardIndex().getImageSet())) {
                    imageProperty.set((Object)value.substring(imageSet.length()));
                } else {
                    imageProperty.set((Object)value.replace("~" + card3D.getCardIndex().getImageSet(), ""));
                }
            }
        }
    }

    @Override
    protected Vector3D getCardRotation(int i) {
        return CARD_ROTATION;
    }

    @Override
    public GameConst.CardLocation getZoneLocation() {
        return GameConst.CardLocation.KEY;
    }
}

