/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game;

import javafx.scene.paint.Color;
import open.batoru.core.Disposable;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.data.CardConst;
import open.batoru.data.ModifiableVariable;
import open.batoru.game.FieldBackground;
import open.batoru.game.FieldStackZone;
import open.batoru.game.FieldZone;
import open.batoru.game.FieldZoneNotificationCollaboLiver;
import open.batoru.game.FieldZoneSpinner;
import open.batoru.game.PlayerField;
import open.batoru.game.Zone;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.Vector3D;
import open.batoru.game._3d.textures.UtilTextureLayer;
import open.batoru.game.animations.AnimationTexturedMeshFlash;
import open.batoru.ui.FX;
import open.batoru.ui.UI;

public class ZoneLRIG
extends FieldStackZone
implements Disposable {
    private static final Vector3D CARD_ROTATION_FACEDOWN = new Vector3D(0.0, 180.0, 0.0);
    private final FieldBackground background;
    private final FieldZoneSpinner spinnerCoins;
    private FieldZoneNotificationCollaboLiver notificationCollaboLiver;
    private ModifiableVariable.OnValueChangedHandler<Integer> handleListenerStateFlags;
    private CardIndex lastListenerOwner;
    private ModifiableVariable.ExternalValue<Double> modExternalValueAssistLimit;

    public ZoneLRIG(double x, double y, FieldBackground background, FieldZoneSpinner spinnerCoins) {
        super(x, y, FieldZone.ZoneType.LRIG);
        this.background = background;
        this.spinnerCoins = spinnerCoins;
        this.modExternalValueAssistLimit = () -> {
            double sum = 0.0;
            PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByZoneFlip(this.isFlipped());
            if (FieldZone.isOccupied(field.getLRIGAssistZoneLeft())) {
                sum += field.getLRIGAssistZoneLeft().getTopCard().getCardIndex().getIndexedInstance().getLimit().getValue().doubleValue();
            }
            if (FieldZone.isOccupied(field.getLRIGAssistZoneRight())) {
                sum += field.getLRIGAssistZoneRight().getTopCard().getCardIndex().getIndexedInstance().getLimit().getValue().doubleValue();
            }
            return sum;
        };
    }

    @Override
    protected Vector3D getCardRotation(int i) {
        return this.getZoneCardList().isEmpty() ? CARD_ROTATION_FACEDOWN : Vector3D.ZERO;
    }

    @Override
    public void addCardToZoneList(Card3D card3D, Zone.ZonePosition addPosition) {
        super.addCardToZoneList(card3D, addPosition);
        if (card3D.getCardIndex().getIndexedInstance() != null) {
            if (addPosition == Zone.ZonePosition.TOP) {
                Card3D card3DTop = this.getTopCard(1);
                if (card3DTop != null) {
                    this.removeListeners(card3DTop.getCardIndex());
                    card3DTop.getCardMeshFace().clearTextureLayers();
                    card3DTop.getCardIndex().getIndexedInstance().resetStats();
                    card3DTop.getCardIndex().setUnderType(GameConst.CardUnderType.UNDER_GENERIC);
                }
                if (card3D.getCardIndex().getLocation() == GameConst.CardLocation.LRIG) {
                    if (card3DTop != null) {
                        card3DTop.getCardIndex().getIndexedInstance().getLimit().removeExternalValue(this.modExternalValueAssistLimit);
                    }
                    card3D.getCardIndex().getIndexedInstance().getLimit().addExternalValue(this.modExternalValueAssistLimit);
                }
                this.addListeners(card3D);
            } else {
                card3D.getCardIndex().setUnderType(GameConst.CardUnderType.UNDER_GENERIC);
            }
        }
    }

    @Override
    public void removeCardFromZoneList(Card3D card3D) {
        if (card3D == this.getTopCard()) {
            this.removeListeners(card3D.getCardIndex());
            if (card3D.getCardIndex().getLocation() == GameConst.CardLocation.LRIG) {
                card3D.getCardIndex().getIndexedInstance().getLimit().removeExternalValue(this.modExternalValueAssistLimit);
                Card3D card3DTop = this.getTopCard(1);
                if (card3DTop != null) {
                    card3DTop.getCardIndex().getIndexedInstance().getLimit().addExternalValue(this.modExternalValueAssistLimit);
                }
            }
        }
        super.removeCardFromZoneList(card3D);
    }

    private void addListeners(Card3D card3D) {
        this.handleListenerStateFlags = (oldValue, newValue) -> FX.run(() -> {
            this.updateStateFlagTexture(card3D, (int)oldValue, (int)newValue, 65536, UtilTextureLayer.TextureType.FROZEN);
            this.updateStateFlagTexture(card3D, (int)oldValue, (int)newValue, 0x200000, UtilTextureLayer.TextureType.DRIVE);
        });
        card3D.getCardIndex().getIndexedInstance().getCardStateFlags().addValueListener(this.handleListenerStateFlags);
        this.lastListenerOwner = card3D.getCardIndex();
    }

    private void removeListeners(CardIndex cardIndex) {
        cardIndex.getIndexedInstance().getCardStateFlags().removeValueListener(this.handleListenerStateFlags);
        this.lastListenerOwner = null;
    }

    public void resetListeners() {
        if (this.lastListenerOwner != null) {
            this.removeListeners(this.lastListenerOwner);
        }
        if (this.getTopCard() != null) {
            this.addListeners(this.getTopCard());
        }
    }

    private void updateStateFlagTexture(Card3D card3D, int oldValue, int newValue, int flag, UtilTextureLayer.TextureType textureType) {
        if ((oldValue & flag) == 0 && (newValue & flag) != 0) {
            card3D.getCardMeshFace().addTextureLayer(UtilTextureLayer.getTexture(textureType));
        } else if ((oldValue & flag) != 0 && (newValue & flag) == 0) {
            card3D.getCardMeshFace().removeTextureLayer(textureType.getAlias());
        }
    }

    @Override
    public void updateZone(Zone.OnRearrangeAnimationInterpolateHandler.RearrangeType rearrangeType) {
        Color color;
        Card3D card3D = this.getTopCard();
        if (!Card3D.isFaceUpOnField(card3D)) {
            return;
        }
        if (this.isFlipped()) {
            UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(card3D.getCardIndex());
        }
        if ((color = CardConst.CardColor.utilCardColorToJavaFXColor(card3D.getCardIndex().getIndexedInstance().getColor().getPrimaryValue(), 1.0, 0.5)) != this.background.getMesh().getMaterial().getDiffuseColor()) {
            AnimationTexturedMeshFlash aniFlash = new AnimationTexturedMeshFlash(this.background.getMesh(), this.background.getMesh().getMaterial().getDiffuseColor(), color, false);
            aniFlash.play();
        }
        if (Game.getCurrentGame().getGameServerPortOffset() != 0) {
            Game.getCurrentGame().getRoom().getPlayerData(Zone.getZoneOwner(this)).getLRIGCenterImageProperty().set((Object)card3D.getCardIndex().getImageSet());
        }
    }

    public FieldZoneSpinner getSpinnerCoins() {
        return this.spinnerCoins;
    }

    public void setNotificationCollaboLivers(FieldZoneNotificationCollaboLiver notificationCollaboLiver) {
        this.notificationCollaboLiver = notificationCollaboLiver;
    }

    public FieldZoneNotificationCollaboLiver getNotificationCollaboLiver() {
        return this.notificationCollaboLiver;
    }

    @Override
    public GameConst.CardLocation getZoneLocation() {
        return GameConst.CardLocation.LRIG;
    }

    @Override
    public void dispose() {
        if (this.getTopCard() != null) {
            this.removeListeners(this.getTopCard().getCardIndex());
            this.getTopCard().getCardIndex().getIndexedInstance().getLimit().removeExternalValue(this.modExternalValueAssistLimit);
        }
        this.modExternalValueAssistLimit = null;
        this.handleListenerStateFlags = null;
        this.lastListenerOwner = null;
        super.dispose();
    }
}

