/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game;

import java.util.ArrayList;
import javafx.scene.paint.Color;
import open.batoru.core.Game;
import open.batoru.core.gameplay.GameConst;
import open.batoru.game.FieldZone;
import open.batoru.game.FieldZoneBarrierIndicators;
import open.batoru.game.Zone;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.Vector3D;

public class ZoneLifeCloth
extends FieldZone {
    private static final Vector3D CARD_ROTATION = new Vector3D(0.0, 180.0, -90.0);
    private static final Vector3D CARD_SKEWED_ROTATION = new Vector3D(-2.0, 180.0, -90.0);
    private static final double OFFSET_FIRST = -1218.0;
    private static final double DEFAULT_SPACE = 114.0;
    private static final double FIT_SIZE = 684.0;
    private static final double OFFSET_PADDING = 15.0;
    private final FieldZoneBarrierIndicators zoneBarrierIndicators = new FieldZoneBarrierIndicators();

    public ZoneLifeCloth(double x, double y) {
        super(x, y, 1054, 269, FieldZone.ZoneType.LIFE_CLOTH);
        this.zoneBarrierIndicators.setTranslate(574.5, -134.5, -56.25);
        this.getNode().getChildren().add((Object)this.zoneBarrierIndicators);
    }

    private double calculateSpacing(int i, int offset) {
        if (i == 0) {
            return -1218.0;
        }
        return 684.0 / (double)(this.getTotalCards() + offset < 7 ? 6 : this.getTotalCards() + offset);
    }

    private double calculateCardOffset(int i) {
        return -340.0 + (double)i * this.calculateSpacing(i, 0);
    }

    private double calculateCardOffsetX(int i, int offset) {
        return (double)(i + 1) * this.calculateSpacing(i, offset) - this.getOffsetPadding(offset);
    }

    private double getOffsetPadding(int offset) {
        return this.getTotalCards() + offset < 7 ? 15.0 : 0.0;
    }

    @Override
    protected Vector3D getCardOriginOffset(int i) {
        return new Vector3D(this.calculateCardOffset(i), 0.0, i > 0 ? -4.0 : 0.0);
    }

    @Override
    protected Vector3D getCardRotation(int i) {
        return i != 0 ? CARD_SKEWED_ROTATION : CARD_ROTATION;
    }

    @Override
    public void updateZone(Zone.OnRearrangeAnimationInterpolateHandler.RearrangeType rearrangeType) {
        if (Game.getCurrentGame().getGameState() != Game.GameState.IN_PROGRESS) {
            return;
        }
        this.flashZoneMesh(rearrangeType == Zone.OnRearrangeAnimationInterpolateHandler.RearrangeType.CARD_ADDED ? Color.GREEN : Color.RED);
        if (Game.getCurrentGame().getGameServerPortOffset() != 0) {
            Game.getCurrentGame().getRoom().getPlayerData(Zone.getZoneOwner(this)).getLifeClothCountProperty().set(this.getTotalCards());
        }
    }

    @Override
    public void prepareRearrangeAnimation(Zone.OnRearrangeAnimationInterpolateHandler.RearrangeType rearrangeType, Zone.ZonePosition addPosition) {
        if (this.getZoneCardList().isEmpty()) {
            return;
        }
        int offset = rearrangeType == Zone.OnRearrangeAnimationInterpolateHandler.RearrangeType.CARD_ADDED ? 0 : -1;
        ArrayList<Zone.RearrangeAnimationData> listData = new ArrayList<Zone.RearrangeAnimationData>();
        for (int i = 1; i < this.getTotalCards(); ++i) {
            double end;
            Card3D card3D = this.getZoneCardList().get(i);
            double start = card3D.getTransX();
            double diff = start - (end = this.calculateCardOffsetX(i, offset));
            if (diff == 0.0) continue;
            listData.add(new Zone.RearrangeAnimationData(card3D, start, diff));
        }
        this.setOnRearrangeAnimationInterpolate(frac -> {
            for (Zone.RearrangeAnimationData data : listData) {
                data.card3D().setTransX(data.start() - data.diff() * frac);
            }
        });
    }

    public FieldZoneBarrierIndicators getZoneBarrierIndicators() {
        return this.zoneBarrierIndicators;
    }

    @Override
    public GameConst.CardLocation getZoneLocation() {
        return GameConst.CardLocation.LIFE_CLOTH;
    }
}

