/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game;

import java.util.ArrayList;
import open.batoru.core.gameplay.GameConst;
import open.batoru.game.Zone;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.Vector3D;
import open.batoru.ui.UI;

public class ZoneReveal
extends Zone {
    public ZoneReveal(double x, double y, double z) {
        super(0, 349);
        this.getNode().setTranslate(x, y, z);
    }

    protected double calculateCardOffset(int i) {
        int sign;
        int num = this.getTotalCards();
        if (num == 0) {
            return 0.0;
        }
        int mid = num / 2;
        int n = sign = i < mid ? -1 : 1;
        if (num % 2 == 0) {
            if (i == mid) {
                return 0.0;
            }
            return (250 + 250 * (mid - 1)) * sign;
        }
        return (250.0f * ((float)(num - 1) / 2.0f) + 125.0f) * (float)sign;
    }

    @Override
    protected Vector3D getCardOriginOffset(int i) {
        return new Vector3D(this.calculateCardOffset(i), 0.0, 0.0);
    }

    @Override
    public void prepareRearrangeAnimation(Zone.OnRearrangeAnimationInterpolateHandler.RearrangeType rearrangeType, Zone.ZonePosition addPosition) {
        if (this.getLastModifiedIndex() == -1 || this.getZoneCardList().isEmpty()) {
            return;
        }
        ArrayList<Zone.RearrangeAnimationData> listData = new ArrayList<Zone.RearrangeAnimationData>();
        for (int i = 0; i < this.getTotalCards(); ++i) {
            Card3D card3D = this.getZoneCardList().get(i);
            double start = card3D.getTransX();
            double end = 125.0;
            if (rearrangeType == Zone.OnRearrangeAnimationInterpolateHandler.RearrangeType.CARD_REMOVED && i < this.getLastModifiedIndex()) {
                end *= -1.0;
            }
            listData.add(new Zone.RearrangeAnimationData(card3D, start, end));
        }
        this.setOnRearrangeAnimationInterpolate(frac -> {
            for (Zone.RearrangeAnimationData data : listData) {
                data.card3D().setTransX(data.start() - data.diff() * frac);
            }
        });
    }

    @Override
    public void addCardToZoneList(Card3D card3D, Zone.ZonePosition addPosition) {
        super.addCardToZoneList(card3D, addPosition);
        if (card3D.getCardIndex().getIndexedInstance() != null) {
            UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(card3D.getCardIndex());
        }
    }

    @Override
    public int getWidth() {
        switch (this.getTotalCards()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 250;
            }
        }
        Card3D nodeFirst = this.getBottomCard();
        Card3D nodeLast = this.getTopCard();
        return (int)(nodeLast.localToScene(nodeLast.getBoundsInLocal()).getMaxX() - nodeFirst.localToScene(nodeLast.getBoundsInLocal()).getMinX());
    }

    @Override
    public GameConst.CardLocation getZoneLocation() {
        return GameConst.CardLocation.REVEALED;
    }
}

