/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game._3d;

import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import open.batoru.ImageCache;
import open.batoru.core.Deck;
import open.batoru.core.Disposable;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.EffectBucket;
import open.batoru.core.gameplay.GameConst;
import open.batoru.game.FieldZone;
import open.batoru.game.Zone;
import open.batoru.game._3d.CardMeshEdge;
import open.batoru.game._3d.CardMeshPlane;
import open.batoru.game._3d.CardViewUnderCardsButton;
import open.batoru.game._3d.Group3D;
import open.batoru.game._3d.Plane;
import open.batoru.game._3d.ShatteredCard;
import open.batoru.ui.UI;

public class Card3D
extends Group3D
implements Disposable {
    private CardIndex cardIndex;
    private ShatteredCard shatter;
    private Plane glow;
    private Zone zoneOwner;
    private final CardMeshPlane cardMeshFace;
    private final CardMeshEdge cardMeshEdge;
    private final CardMeshPlane cardMeshBack;
    private final CardViewUnderCardsButton buttonViewUnderCards = new CardViewUnderCardsButton();

    public Card3D(Deck.DeckType deckType) {
        this.cardIndex = new CardIndex(deckType == Deck.DeckType.MAIN ? GameConst.CardLocation.DECK_MAIN : GameConst.CardLocation.DECK_LRIG);
        this.cardMeshFace = new CardMeshPlane(null);
        this.cardMeshFace.setVisible(false);
        this.cardMeshEdge = new CardMeshEdge(deckType);
        this.cardMeshBack = new CardMeshPlane(deckType == Deck.DeckType.MAIN ? ImageCache.INSTANCE.getMainCardBackImage() : ImageCache.INSTANCE.getLRIGCardBackImage());
        this.cardMeshFace.setTransZ(-4.0);
        this.cardMeshBack.setRotateY(180.0);
        this.getChildren().addAll((Object[])new Node[]{this.cardMeshFace, this.cardMeshEdge, this.cardMeshBack});
        this.setPivot(0.0, 0.0, -2.0);
        this.installMouseEvents();
    }

    public final void installMouseEvents() {
        this.setOnMouseEntered(e -> {
            if (this.cardIndex.getIndexedInstance() != null && !e.isAltDown() && this.cardMeshFace.isVisible() && this.cardIndex.getImageSet() != null) {
                UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(this.cardIndex);
                if (!CardIndex.isOwnCard(this.cardIndex)) {
                    UI.getTabGame().getFieldSceneOverlay().getCardPreview().setLock(true);
                }
            }
            if (this.zoneOwner != null) {
                Zone patt0$temp = this.zoneOwner;
                if (patt0$temp instanceof FieldZone) {
                    FieldZone fieldZone = (FieldZone)patt0$temp;
                    fieldZone.getZoneMesh().fireEvent(e);
                }
                if (this == this.zoneOwner.getTopCard() && this.zoneOwner.getTotalCards() >= 2 && CardViewUnderCardsButton.getAllowedUnderTargetsList().isEmpty() && (GameConst.CardLocation.isPublic(this.zoneOwner.getZoneLocation()) && this.zoneOwner.getZoneLocation() != GameConst.CardLocation.ENER && this.zoneOwner.getZoneLocation() != GameConst.CardLocation.REVEALED || !this.zoneOwner.isFlipped() && this.zoneOwner.getZoneLocation() == GameConst.CardLocation.DECK_LRIG && !Game.getCurrentGame().isNeutralPerspectiveGame())) {
                    this.showViewCardsUnderButton();
                }
            }
        });
        this.setOnMouseExited(e -> {
            if (this.zoneOwner != null) {
                Zone patt0$temp = this.zoneOwner;
                if (patt0$temp instanceof FieldZone) {
                    FieldZone fieldZone = (FieldZone)patt0$temp;
                    fieldZone.getZoneMesh().fireEvent(e);
                }
                if (CardViewUnderCardsButton.getAllowedUnderTargetsList().isEmpty()) {
                    this.hideViewCardsUnderButton();
                }
            }
            UI.getTabGame().getFieldSceneOverlay().getCardPreview().setLock(false);
        });
        this.setOnMouseClicked(e -> Game.getCurrentGame().getPlayerControl().onCardClicked(this));
    }

    public void showViewCardsUnderButton() {
        if (this.getChildren().contains((Object)this.buttonViewUnderCards)) {
            return;
        }
        this.buttonViewUnderCards.setTransZ(this.getRotateY() == 0.0 ? -20.0 : 20.0);
        this.buttonViewUnderCards.setRotateY(this.getRotateY());
        this.buttonViewUnderCards.setOwnerZone(this.zoneOwner);
        this.getChildren().add((Object)this.buttonViewUnderCards);
    }

    public void hideViewCardsUnderButton() {
        this.getChildren().remove((Object)this.buttonViewUnderCards);
    }

    public CardViewUnderCardsButton getViewUnderCardsButton() {
        return this.buttonViewUnderCards;
    }

    public void updateImageSet() {
        if (this.cardIndex.getImageSet() != null) {
            this.cardMeshFace.setDefaultTexture(ImageCache.INSTANCE.getCardImage(this.cardIndex.getImageSet()));
            this.cardMeshFace.setVisible(true);
        } else {
            this.cardMeshFace.setDefaultTexture(null);
            this.cardMeshFace.setVisible(false);
        }
    }

    @Deprecated
    public void setCardIndex(CardIndex cardIndex) {
        this.cardIndex = cardIndex;
        cardIndex.setSourceCard3D(this);
        this.updateImageSet();
    }

    final void adoptCardIndex(Card3D card3D) {
        this.cardIndex = card3D.getCardIndex();
        this.updateImageSet();
    }

    public void setImageSet(int idCard, String imageSet) {
        this.cardIndex.setImageSet(idCard, imageSet);
        this.updateImageSet();
    }

    public void clearCardIndex() {
        if (GameConst.CardLocation.isPublic(this.cardIndex.getLocation()) || GameConst.CardLocation.isPlayerPrivate(this.cardIndex.getLocation()) && (CardIndex.isOwnCard(this.cardIndex) || Game.getCurrentGame().isNeutralPerspectiveGame())) {
            return;
        }
        EffectBucket sourceBucket = Game.getCurrentGame().getGameRules().getEffectProcessor().getPlayerBucket(this.cardIndex.getCurrentOwnerSafe());
        if (sourceBucket.hasNoAwaitingAbilities(this.cardIndex)) {
            this.cardIndex.clearImageSet();
            this.updateImageSet();
        } else {
            sourceBucket.setClearCardIndexAfterFinalResolution(this.cardIndex);
        }
    }

    public CardMeshPlane getVisibleMesh() {
        return this.getCardIndex().getIndexedInstance() != null && this.getRotateY() != 180.0 ? this.cardMeshFace : this.cardMeshBack;
    }

    public CardMeshPlane getCardMeshFace() {
        return this.cardMeshFace;
    }

    public CardMeshEdge getCardMeshEdge() {
        return this.cardMeshEdge;
    }

    public CardMeshPlane getCardMeshBack() {
        return this.cardMeshBack;
    }

    public CardIndex getCardIndex() {
        return this.cardIndex;
    }

    public void setOwnerZone(Zone zone) {
        this.zoneOwner = zone;
    }

    public Zone getOwnerZone() {
        return this.zoneOwner;
    }

    public void showFace() {
        this.cardMeshFace.setVisible(true);
    }

    public void showBack() {
        this.cardMeshBack.setVisible(true);
    }

    public void hideFace() {
        this.cardMeshFace.setVisible(false);
    }

    public void hideBack() {
        this.cardMeshBack.setVisible(false);
    }

    public void setShouldClearImageSet(boolean set) {
        if (set) {
            Game.getCurrentGame().getGameData().addPrivateCardImageSetToClear(this);
        } else {
            Game.getCurrentGame().getGameData().removePrivateCardImageSetToClear(this);
        }
    }

    public boolean shouldClearImageSet() {
        return Game.getCurrentGame().getGameData().shouldClearPrivateCardImageSet(this);
    }

    public static boolean isFaceUpOnField(Card3D card3D) {
        return card3D != null && card3D.getCardIndex().getIndexedInstance() != null && card3D.getCardIndex().isFaceUp() && GameConst.CardLocation.isOnField(card3D.getCardIndex().getLocation()) && !card3D.getCardIndex().getIndexedInstance().isState(256);
    }

    public static boolean isMainDeckCard(Card3D card3D) {
        return card3D != null && card3D.getCardMeshBack().getDefaultTexture().equals(ImageCache.INSTANCE.getMainCardBackImage());
    }

    public static Game.GamePlayerRole getCurrentOwner(Card3D card3D) {
        return card3D.getOwnerZone().isFlipped() ? Game.GamePlayerRole.getOpponentRole(Game.getCurrentGame().getPlayerRole()) : Game.getCurrentGame().getPlayerRole();
    }

    public void showAsPrivate(boolean isMainDeckCard) {
        this.cardMeshFace.setDefaultTexture(isMainDeckCard ? ImageCache.INSTANCE.getMainCardBackImage() : ImageCache.INSTANCE.getLRIGCardBackImage());
        this.cardMeshFace.setVisible(true);
    }

    public void hidePrivate() {
        this.cardMeshFace.setDefaultTexture(null);
        this.cardMeshFace.setVisible(false);
    }

    public void shatter() {
        if (this.shatter != null) {
            return;
        }
        this.hideFace();
        this.hideBack();
        this.cardMeshEdge.setVisible(false);
        this.shatter = new ShatteredCard(this);
        this.getChildren().add((Object)this.shatter);
    }

    public void removeShatter() {
        if (this.shatter == null) {
            return;
        }
        this.showFace();
        this.showBack();
        this.cardMeshEdge.setVisible(true);
        this.getChildren().remove((Object)this.shatter);
        this.shatter.dispose();
        this.shatter = null;
    }

    public ShatteredCard getShatter() {
        return this.shatter;
    }

    public void glow(Color color) {
        if (this.glow == null) {
            Image texture = ImageCache.INSTANCE.getImage("textures/gfx/card_glow.png");
            this.glow = new Plane((int)texture.getWidth(), (int)texture.getHeight(), texture);
            this.glow.setManaged(false);
            UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(CardIndex.getOriginalOwner(this.cardIndex.getId())).getChildren().add((Object)this.glow);
            this.glow.setTranslate(this);
            this.glow.setRotate(this);
            this.setOnTranslated((x, y, z) -> this.glow.setTranslate(x, y, z));
        } else {
            this.glow.setVisible(true);
        }
        this.glow.getMaterial().setDiffuseColor(color);
    }

    public void removeGlow() {
        if (this.glow != null) {
            this.glow.setVisible(false);
        }
    }

    @Override
    public void dispose() {
        this.setOnMouseEntered(null);
        this.setOnMouseExited(null);
        this.setOnMouseClicked(null);
        this.cardMeshFace.dispose();
        this.cardMeshBack.dispose();
        this.buttonViewUnderCards.dispose();
        this.removeShatter();
        this.zoneOwner = null;
        if (this.cardIndex.getSourceCard3D() == this) {
            this.cardIndex.setSourceCard3D(null);
        }
        this.cardIndex = null;
    }
}

