/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game._3d;

import open.batoru.core.Deck;
import open.batoru.core.Game;
import open.batoru.game.FieldZone;
import open.batoru.game.Zone;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.textures.UtilTextureLayer;
import open.batoru.ui.UI;

public class Card3DSubstitute
extends Card3D {
    private Card3D source;

    public Card3DSubstitute(Card3D source) {
        super(Deck.DeckType.MAIN);
        this.source = source;
        this.adoptCardIndex(source);
        this.getCardMeshFace().addTextureLayer(UtilTextureLayer.getTexture(UtilTextureLayer.TextureType.TANABATA));
        this.installSubstituteMouseEvents();
    }

    private void installSubstituteMouseEvents() {
        this.setOnMouseEntered(e -> {
            UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(this.getCardIndex());
            Zone patt0$temp = this.source.getOwnerZone();
            if (patt0$temp instanceof FieldZone) {
                FieldZone fieldZone = (FieldZone)patt0$temp;
                fieldZone.getZoneMesh().fireEvent(e);
            }
        });
        this.setOnMouseExited(e -> {
            Zone patt0$temp = this.source.getOwnerZone();
            if (patt0$temp instanceof FieldZone) {
                FieldZone fieldZone = (FieldZone)patt0$temp;
                fieldZone.getZoneMesh().fireEvent(e);
            }
        });
        this.setOnMouseClicked(e -> Game.getCurrentGame().getPlayerControl().onCardClicked(this.source));
    }

    public Card3D getSource() {
        return this.source;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.source = null;
    }
}

