/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game._3d;

import java.util.ArrayList;
import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.scene.Cursor;
import javafx.scene.paint.Color;
import javafx.util.Duration;
import open.batoru.ImageCache;
import open.batoru.core.Disposable;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.pickers.CardPicker;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.game.Zone;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.Plane;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.game.overlay.window.OverlayWindowCard;
import open.batoru.game.overlay.window.OverlayWindowCardList;
import open.batoru.game.overlay.window.OverlayWindowViewDeck;
import open.batoru.parsers.LanguageParser;

public class CardViewUnderCardsButton
extends Plane
implements Disposable {
    private OverlayWindowCard sourceWindow;
    private CardPicker sourcePicker;
    private Timeline aniFlash;
    private static final List<Card3D> listAllowedUnderTargetCards = new ArrayList<Card3D>();

    public CardViewUnderCardsButton() {
        super(96, ImageCache.INSTANCE.getImage(ImageCache.getBorderIconTexturePath(TargetFilter.TargetHint.LOOK)));
        this.setCursor(Cursor.HAND);
        this.setPickOnBounds(true);
    }

    public void setSourcePicker(OverlayWindowCard window, CardPicker picker) {
        this.sourceWindow = window;
        this.sourcePicker = picker;
    }

    public void setOwnerZone(Zone zone) {
        this.setTransY((double)(zone.isFlipped() ? -238 : 238) * 0.5);
        if (!GameConst.CardLocation.isDeck(zone.getZoneLocation())) {
            this.setOnMouseClicked(e -> {
                OverlayWindowCardList window;
                if (OverlayWindow.isAddedToFieldOverlay("under" + String.valueOf(zone))) {
                    return;
                }
                List<Card3D> listUnder = zone.getZoneLocation() != GameConst.CardLocation.CHECK_ZONE && zone.getTopCard().getCardIndex().getUnderType().getUnderCategory() != GameConst.CardUnderCategory.ZONE ? zone.getZoneCardList().subList(0, zone.getTotalCards() - 1) : zone.getZoneCardList();
                if (this.sourceWindow == null && this.sourcePicker == null) {
                    window = new OverlayWindowCardList(LanguageParser.getString("UI_GAME_WINDOW_UNDER_TITLE_VIEW"), null, listUnder);
                    window.setIsInformationWindow();
                } else {
                    window = new OverlayWindowCardList(LanguageParser.getString(zone.getZoneLocation() != GameConst.CardLocation.CHECK_ZONE ? "UI_GAME_WINDOW_UNDER_TITLE_CHOICE" : "UI_GAME_WINDOW_TARGET_DESC"), null, listUnder, this.sourcePicker, 0);
                    OverlayWindow.hideWindow(this.sourceWindow);
                }
                window.setAlias("under" + String.valueOf(zone));
                OverlayWindow.addToFieldOverlay(window);
                window.getConfirmButton().setOnAction(e2 -> {
                    OverlayWindow.removeFromFieldOverlay(window);
                    if (this.sourcePicker != null) {
                        for (Card3D card3D : window.getChangedPickedStateList()) {
                            this.sourcePicker.pick(card3D);
                        }
                    }
                    if (this.sourceWindow != null) {
                        OverlayWindow.showWindow(this.sourceWindow);
                        if (this.sourcePicker != null && this.sourcePicker.getMaxPicks() == 1 && !this.sourcePicker.getPickedList().isEmpty()) {
                            this.sourceWindow.getConfirmButton().fire();
                        }
                    }
                });
                e.consume();
            });
        } else {
            this.setOnMouseClicked(e -> {
                CardViewUnderCardsButton.showViewDeckWindow(zone);
                e.consume();
            });
        }
    }

    public void playFlashAnimation() {
        if (this.aniFlash != null) {
            this.aniFlash.stop();
        }
        this.aniFlash = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)250.0), e -> this.getMaterial().setDiffuseColor(Color.LIME), new KeyValue[0]), new KeyFrame(Duration.millis((double)500.0), e -> this.getMaterial().setDiffuseColor(Color.WHITE), new KeyValue[0])});
        this.aniFlash.setCycleCount(-1);
        this.aniFlash.play();
    }

    public void stopFlashAnimation() {
        if (this.aniFlash == null) {
            return;
        }
        this.aniFlash.stop();
        this.aniFlash = null;
        this.getMaterial().setDiffuseColor(Color.WHITE);
    }

    public static void showViewDeckWindow(Zone zone) {
        OverlayWindowViewDeck window = new OverlayWindowViewDeck(CardIndex.getOriginalOwner(zone.getTopCard().getCardIndex().getId()), zone.getZoneLocation());
        window.setAlias("view" + String.valueOf(zone));
        window.setIsInformationWindow();
        OverlayWindow.addToFieldOverlay(window);
        window.getConfirmButton().setOnAction(e -> OverlayWindow.removeFromFieldOverlay(window));
    }

    @Override
    public void dispose() {
        this.setOnMouseClicked(null);
        this.stopFlashAnimation();
        this.getMaterial().setDiffuseMap(null);
    }

    public static void addToAllowedUnderTargetsList(Card3D card3D) {
        card3D.showViewCardsUnderButton();
        card3D.getViewUnderCardsButton().playFlashAnimation();
        listAllowedUnderTargetCards.add(card3D);
    }

    public static void clearAllowedUnderTargetsList() {
        listAllowedUnderTargetCards.forEach(card3D -> {
            card3D.getViewUnderCardsButton().setSourcePicker(null, null);
            card3D.getViewUnderCardsButton().stopFlashAnimation();
            card3D.hideViewCardsUnderButton();
        });
        listAllowedUnderTargetCards.clear();
    }

    public static List<Card3D> getAllowedUnderTargetsList() {
        return listAllowedUnderTargetCards;
    }
}

