/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game._3d;

import javafx.scene.Cursor;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import open.batoru.ImageCache;
import open.batoru.core.Game;
import open.batoru.data.CardConst;
import open.batoru.game.FieldZoneEnerGroup;
import open.batoru.game._3d.Plane;
import open.batoru.game._3d.textures.UtilTexture;

public class EnerColor
extends Plane {
    private final FieldZoneEnerGroup sourceEnerGroup;
    private final CardConst.CardColor color;
    private final int offset;
    private boolean isLocked;
    private OnEnerColorLockedHandler handlerLocked;

    public EnerColor(FieldZoneEnerGroup sourceEnerGroup, CardConst.CardColor color, int offset) {
        super((int)sourceEnerGroup.getEnerColorSize(), ImageCache.INSTANCE.getImage(ImageCache.getColorTexturePath(color)));
        this.sourceEnerGroup = sourceEnerGroup;
        this.color = color;
        this.offset = offset;
        this.getMaterial().setDiffuseColor(Color.SILVER);
        this.setTransY((double)(-offset) * sourceEnerGroup.getEnerColorSize() * 1.5);
        this.setRotateZ(90.0);
        this.setOnMouseEntered(e -> {
            if (!this.isLocked && sourceEnerGroup.getSelectedEnerColor() == null) {
                this.getMaterial().setDiffuseColor(Color.WHITE);
                this.setCursor(Cursor.HAND);
            }
        });
        this.setOnMouseExited(e -> {
            if (!this.isLocked && sourceEnerGroup.getSelectedEnerColor() == null) {
                this.getMaterial().setDiffuseColor(Color.SILVER);
                this.setCursor(Cursor.DEFAULT);
            }
        });
        this.setOnMouseClicked(e -> {
            if (!this.isLocked) {
                Game.getCurrentGame().getPlayerControl().onEnerColorClicked(this);
            }
        });
    }

    public FieldZoneEnerGroup getSourceEnerGroup() {
        return this.sourceEnerGroup;
    }

    public CardConst.CardColor getColor() {
        return this.color;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setLock(boolean lock) {
        this.isLocked = lock;
        this.getMaterial().setDiffuseMap((Image)(lock ? UtilTexture.grayscale(ImageCache.INSTANCE.getImage(ImageCache.getColorTexturePath(this.color))) : ImageCache.INSTANCE.getImage(ImageCache.getColorTexturePath(this.color))));
        if (this.handlerLocked != null) {
            this.handlerLocked.handle();
        }
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void setOnEnerColorLocked(OnEnerColorLockedHandler handlerLocked) {
        this.handlerLocked = handlerLocked;
    }

    @FunctionalInterface
    public static interface OnEnerColorLockedHandler {
        public void handle();
    }
}

