/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game._3d;

import javafx.scene.image.Image;
import open.batoru.game._3d.TexturedMesh;

public class Plane
extends TexturedMesh {
    public Plane(int size, Image texture) {
        this(size, size, texture);
    }

    public Plane(int width, int height, Image texture) {
        this(width, height, texture, TextureTrimMode.NONE);
    }

    public Plane(int width, int height, Image texture, TextureTrimMode textureTrimMode) {
        super(texture);
        this.getMesh().getPoints().addAll(new float[]{(float)(-width) * 0.5f, (float)(-height) * 0.5f, 0.0f, (float)width * 0.5f, (float)(-height) * 0.5f, 0.0f, (float)(-width) * 0.5f, (float)height * 0.5f, 0.0f, (float)width * 0.5f, (float)height * 0.5f, 0.0f});
        this.getMesh().getTexCoords().addAll(textureTrimMode.values);
        this.getMesh().getFaces().addAll(new int[]{0, 0, 2, 2, 1, 1, 3, 3, 1, 1, 2, 2});
    }

    public static enum TextureTrimMode {
        NONE(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f}),
        UPPER_EDGE(new float[]{0.0f, 0.1f, 1.0f, 0.1f, 0.0f, 1.0f, 1.0f, 1.0f}),
        LOWER_EDGE(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.9f, 1.0f, 0.9f}),
        FRAME(new float[]{0.1f, 0.1f, 0.9f, 0.1f, 0.1f, 0.9f, 0.9f, 0.9f});

        private final float[] values;

        private TextureTrimMode(float[] values) {
            this.values = values;
        }
    }
}

