/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game._3d.textures;

import javafx.scene.image.Image;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import open.batoru.game._3d.textures.TextureLayer;

public class PostProcessPixelTextureLayer
extends TextureLayer<PostProcessPixelHandler> {
    public PostProcessPixelTextureLayer(String alias, PostProcessPixelHandler postProcessPixelHandler) {
        super(alias, postProcessPixelHandler);
    }

    public static WritableImage apply(Image image, PostProcessPixelHandler postProcessPixelHandler) {
        PixelReader reader = image.getPixelReader();
        WritableImage texture = new WritableImage(reader, (int)image.getWidth(), (int)image.getHeight());
        PixelWriter writer = texture.getPixelWriter();
        int x = 0;
        while ((double)x < texture.getWidth()) {
            int y = 0;
            while ((double)y < texture.getHeight()) {
                writer.setColor(x, y, postProcessPixelHandler.process(x, y, reader.getColor(x, y)));
                ++y;
            }
            ++x;
        }
        return texture;
    }

    @FunctionalInterface
    public static interface PostProcessPixelHandler {
        public Color process(int var1, int var2, Color var3);
    }
}

