/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game._3d.textures;

import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import javafx.scene.effect.Effect;
import javafx.scene.paint.Color;
import open.batoru.ImageCache;
import open.batoru.game._3d.textures.ColorTextureLayer;
import open.batoru.game._3d.textures.EffectTextureLayer;
import open.batoru.game._3d.textures.ImageTextureLayer;
import open.batoru.game._3d.textures.PostProcessPixelTextureLayer;
import open.batoru.game._3d.textures.TextureLayer;

public final class UtilTextureLayer {
    private static final Map<TextureType, Supplier<TextureLayer<?>>> textures = new EnumMap(TextureType.class);

    public static TextureLayer<?> getTexture(TextureType textureType) {
        return textures.get((Object)textureType).get();
    }

    private static ImageTextureLayer createNewDiffuseImageTexture(TextureType textureType) {
        return new ImageTextureLayer(textureType.getAlias(), ImageCache.INSTANCE.getImage("textures/zones/overlay/card/" + textureType.getAlias() + ".png"));
    }

    private static ImageTextureLayer createNewSelfIlluminationImageTexture(TextureType textureType) {
        return new ImageTextureLayer(textureType.getAlias(), ImageCache.INSTANCE.getImage("textures/zones/overlay/card/" + textureType.getAlias() + ".png"), ImageTextureLayer.ImageLayerType.SELF_ILLUMINATION);
    }

    private static ColorTextureLayer createNewColorTexture(TextureType textureType, Color color) {
        return new ColorTextureLayer(textureType.getAlias(), color);
    }

    private static EffectTextureLayer createNewEffectTexture(TextureType textureType, Effect effect) {
        return new EffectTextureLayer(textureType.getAlias(), effect);
    }

    private static PostProcessPixelTextureLayer createNewPostProcessPixelTextureLayer(TextureType textureType, PostProcessPixelTextureLayer.PostProcessPixelHandler postProcessPixelHandler) {
        return new PostProcessPixelTextureLayer(textureType.getAlias(), postProcessPixelHandler);
    }

    private UtilTextureLayer() {
    }

    static {
        textures.put(TextureType.FROZEN, () -> UtilTextureLayer.createNewSelfIlluminationImageTexture(TextureType.FROZEN));
        textures.put(TextureType.AWAKENED, () -> UtilTextureLayer.createNewSelfIlluminationImageTexture(TextureType.AWAKENED));
        textures.put(TextureType.CANTATK, () -> UtilTextureLayer.createNewSelfIlluminationImageTexture(TextureType.CANTATK));
        textures.put(TextureType.LANCER, () -> UtilTextureLayer.createNewSelfIlluminationImageTexture(TextureType.LANCER));
        textures.put(TextureType.SLANCER, () -> UtilTextureLayer.createNewSelfIlluminationImageTexture(TextureType.SLANCER));
        textures.put(TextureType.MULTIENER, () -> UtilTextureLayer.createNewSelfIlluminationImageTexture(TextureType.MULTIENER));
        textures.put(TextureType.DISABLEATK, () -> UtilTextureLayer.createNewDiffuseImageTexture(TextureType.DISABLEATK));
        textures.put(TextureType.SHOOT, () -> UtilTextureLayer.createNewDiffuseImageTexture(TextureType.SHOOT));
        textures.put(TextureType.TANABATA, () -> UtilTextureLayer.createNewDiffuseImageTexture(TextureType.TANABATA));
        textures.put(TextureType.DRIVE, () -> UtilTextureLayer.createNewDiffuseImageTexture(TextureType.DRIVE));
        textures.put(TextureType.SHADOW, () -> UtilTextureLayer.createNewColorTexture(TextureType.SHADOW, Color.DIMGREY));
        textures.put(TextureType.SELECTED, () -> UtilTextureLayer.createNewColorTexture(TextureType.SELECTED, Color.GREY));
        textures.put(TextureType.DISABLED, () -> UtilTextureLayer.createNewPostProcessPixelTextureLayer(TextureType.DISABLED, (x, y, color) -> color.grayscale()));
    }

    public static enum TextureType {
        FROZEN("frozen"),
        AWAKENED("awakened"),
        CANTATK("cantatk"),
        LANCER("lancer"),
        SLANCER("slancer"),
        MULTIENER("multiener"),
        DISABLEATK("disableatk"),
        SHOOT("shoot"),
        TANABATA("tanabata"),
        DRIVE("drive"),
        SHADOW("shadow"),
        SELECTED("selected"),
        DISABLED("disabled");

        private final String alias;

        private TextureType(String alias) {
            this.alias = alias;
        }

        public String getAlias() {
            return this.alias;
        }
    }
}

