/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.animations;

import javafx.animation.Interpolator;
import open.batoru.game.Zone;
import open.batoru.game.ZoneLRIG;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.Vector3D;
import open.batoru.game.animations.tracker.TrackableAnimation;

public class AnimationCardFlip
extends TrackableAnimation {
    private final Card3D card3D;
    public static final int DURATION = 600;
    private double startZ;
    private double diffZ;
    private Vector3D rotationStart;
    private Vector3D rotationDiff;
    private Vector3D rotationOffset = Vector3D.ZERO;
    private final boolean shouldFly;

    public AnimationCardFlip(Card3D card3D) {
        this(card3D, true);
    }

    public AnimationCardFlip(Card3D card3D, boolean shouldFly) {
        this.setCycleDuration(600.0);
        this.setInterpolator(Interpolator.EASE_BOTH);
        this.card3D = card3D;
        this.shouldFly = shouldFly;
        if (shouldFly) {
            this.setOnAnimationFinished(() -> {
                Zone zone = card3D.getCardIndex().getZoneByLocation();
                if (zone != null) {
                    zone.updateZone(Zone.OnRearrangeAnimationInterpolateHandler.RearrangeType.CARD_ADDED);
                    if (zone instanceof ZoneLRIG) {
                        ZoneLRIG zoneLRIG = (ZoneLRIG)zone;
                        zoneLRIG.resetListeners();
                    }
                }
            });
        }
    }

    public void setRotationOffset(Vector3D rotationOffset) {
        this.rotationOffset = rotationOffset;
    }

    @Override
    public void play() {
        this.startZ = this.card3D.getTransZ();
        this.diffZ = this.startZ - 500.0;
        this.rotationStart = new Vector3D(this.card3D, Vector3D.VectorType.ROTATION);
        Vector3D rotationEnd = new Vector3D(this.card3D, Vector3D.VectorType.ROTATION);
        rotationEnd.setY((rotationEnd.getY() + 180.0) % 360.0);
        this.rotationDiff = Vector3D.subtract(Vector3D.add(rotationEnd, this.rotationOffset), this.rotationStart);
        super.play();
    }

    protected void interpolate(double frac) {
        if (this.shouldFly) {
            this.card3D.setTransZ(this.startZ - this.diffZ * (Math.abs(0.5 - frac) - 0.5));
        }
        this.card3D.setRotate(this.rotationStart, this.rotationDiff, frac);
    }
}

