/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.animations;

import javafx.animation.Interpolator;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.Group3D;
import open.batoru.game.animations.tracker.TrackableAnimation;

public class AnimationCardLift
extends TrackableAnimation {
    private final Group3D card3D;
    private static final int DURATION = 500;
    private int distance = 240;
    private double startZ;

    public AnimationCardLift(Card3D card3D) {
        this.setCycleDuration(500.0);
        this.setInterpolator(Interpolator.EASE_OUT);
        this.card3D = card3D;
    }

    @Override
    public void play() {
        this.startZ = this.card3D.getTransZ();
        super.play();
    }

    public void reverse() {
        this.distance = -this.distance;
    }

    protected void interpolate(double frac) {
        this.card3D.setTransZ(this.startZ - (double)this.distance * frac);
    }
}

