/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.animations;

import javafx.animation.Interpolator;
import open.batoru.game.Zone;
import open.batoru.game.ZoneEner;
import open.batoru.game._3d.Card3DSubstitute;
import open.batoru.game._3d.Vector3D;
import open.batoru.game.animations.tracker.TrackableAnimation;
import open.batoru.ui.UI;

public class AnimationCardMoveInsertEnerSubstitute
extends TrackableAnimation {
    private static final int DURATION = 500;
    private static final int DISTANCE = 1300;
    private final Card3DSubstitute card3DSubstitute;
    private final ZoneEner zoneEner;
    private double startX;

    public AnimationCardMoveInsertEnerSubstitute(Card3DSubstitute card3DSubstitute, ZoneEner zoneEner) {
        this.setCycleDuration(500.0);
        this.setInterpolator(Interpolator.LINEAR);
        this.card3DSubstitute = card3DSubstitute;
        this.zoneEner = zoneEner;
        this.setOnAnimationFinished(this::onAnimationFinished);
    }

    @Override
    public void play() {
        UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByZoneFlip(this.zoneEner.isFlipped()).getChildren().add((Object)this.card3DSubstitute);
        this.card3DSubstitute.setRotate(this.zoneEner.getNextCardRotation());
        Vector3D origin = this.zoneEner.getNextCardOrigin();
        this.startX = origin.getX();
        this.card3DSubstitute.setTranslate(origin);
        this.zoneEner.prepareNextModifiedIndex(this.zoneEner.getTotalCards());
        this.zoneEner.prepareRearrangeAnimation(Zone.OnRearrangeAnimationInterpolateHandler.RearrangeType.CARD_ADDED, Zone.ZonePosition.TOP);
        super.play();
    }

    protected void interpolate(double frac) {
        this.zoneEner.interpolateRearrangeAnimation(frac);
        this.card3DSubstitute.setTransX(this.startX - 1300.0 * (1.0 - frac));
    }

    private void onAnimationFinished() {
        this.zoneEner.setOnRearrangeAnimationInterpolate(null);
        this.zoneEner.addCardToZoneList(this.card3DSubstitute, Zone.ZonePosition.TOP);
        this.zoneEner.updateZone(Zone.OnRearrangeAnimationInterpolateHandler.RearrangeType.CARD_ADDED);
    }
}

