/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.animations;

import javafx.animation.Interpolator;
import open.batoru.game.Zone;
import open.batoru.game.ZoneEner;
import open.batoru.game._3d.Card3DSubstitute;
import open.batoru.game.animations.tracker.TrackableAnimation;
import open.batoru.ui.UI;

public class AnimationCardMoveRemoveEnerSubstitute
extends TrackableAnimation {
    private static final int DURATION = 500;
    private final Card3DSubstitute card3DSubstitute;
    private final ZoneEner zoneEner;

    public AnimationCardMoveRemoveEnerSubstitute(Card3DSubstitute card3DSubstitute, ZoneEner zoneEner) {
        this.setCycleDuration(500.0);
        this.setInterpolator(Interpolator.LINEAR);
        this.card3DSubstitute = card3DSubstitute;
        this.zoneEner = zoneEner;
        this.setOnAnimationFinished(this::onAnimationFinished);
    }

    @Override
    public void play() {
        UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByZoneFlip(this.zoneEner.isFlipped()).getChildren().remove((Object)this.card3DSubstitute);
        this.zoneEner.getZoneCardList().remove(this.card3DSubstitute);
        this.zoneEner.prepareRearrangeAnimation(Zone.OnRearrangeAnimationInterpolateHandler.RearrangeType.CARD_REMOVED, Zone.ZonePosition.TOP);
        super.play();
    }

    protected void interpolate(double frac) {
        this.zoneEner.interpolateRearrangeAnimation(frac);
    }

    private void onAnimationFinished() {
        this.zoneEner.setOnRearrangeAnimationInterpolate(null);
        this.zoneEner.updateZone(Zone.OnRearrangeAnimationInterpolateHandler.RearrangeType.CARD_REMOVED);
    }
}

